/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtils {
    private static Logger log = LoggerFactory.getLogger(NetworkUtils.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static TypedProperties systemProps = null;
    private static TypedProperties env = null;
    private static TypedProperties network = null;
    private static final int WINDOWS_OS = 1;
    private static final int X11_OS = 2;
    private static final int MAC_OS = 3;
    private static final int UNKNOWN_OS = -1;
    private static final int OS_TYPE = SystemUtils.determineOSType();
    private static Map<String, Thread> shutdownHooks = new Hashtable<String, Thread>();

    private SystemUtils() {
    }

    public static synchronized TypedProperties getSystemProperties() {
        if (systemProps == null) {
            TypedProperties props = new TypedProperties();
            SystemUtils.addOtherSystemProperties(props);
            systemProps = props;
        }
        return systemProps;
    }

    private static void addOtherSystemProperties(TypedProperties props) {
        try {
            Properties sysProps = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

                @Override
                public Properties run() {
                    return System.getProperties();
                }
            });
            Enumeration<?> en = sysProps.propertyNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                try {
                    if (props.contains(name)) continue;
                    props.setProperty(name, System.getProperty(name));
                }
                catch (SecurityException e) {
                    if (debugEnabled) {
                        log.debug(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    log.info(e.getMessage());
                }
            }
        }
        catch (SecurityException e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.info(e.getMessage());
        }
    }

    public static TypedProperties getRuntimeInformation() {
        TypedProperties props = new TypedProperties();
        String s = null;
        try {
            s = String.valueOf(Runtime.getRuntime().availableProcessors());
            props.setProperty("availableProcessors", s);
            s = String.valueOf(Runtime.getRuntime().freeMemory());
            props.setProperty("freeMemory", s);
            s = String.valueOf(Runtime.getRuntime().totalMemory());
            props.setProperty("totalMemory", s);
            s = String.valueOf(Runtime.getRuntime().maxMemory());
            props.setProperty("maxMemory", s);
        }
        catch (SecurityException e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.info(e.getMessage());
        }
        return props;
    }

    public static synchronized TypedProperties getStorageInformation() {
        TypedProperties props = new TypedProperties();
        File[] roots = File.listRoots();
        if (roots == null || roots.length <= 0) {
            return props;
        }
        boolean atLeastJdk16 = true;
        Method usableSpaceMethod = null;
        Method freeSpaceMethod = null;
        Method totalSpaceMethod = null;
        try {
            usableSpaceMethod = File.class.getMethod("getUsableSpace", new Class[0]);
            freeSpaceMethod = File.class.getMethod("getFreeSpace", new Class[0]);
            totalSpaceMethod = File.class.getMethod("getTotalSpace", new Class[0]);
        }
        catch (Exception e) {
            atLeastJdk16 = false;
        }
        props.setProperty("host.roots.number", String.valueOf(roots.length));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < roots.length; ++i) {
            try {
                if (i > 0) {
                    sb.append(' ');
                }
                String s = roots[i].getCanonicalPath();
                sb.append(s);
                String prefix = "root." + i;
                props.setProperty(prefix + ".name", s);
                if (!atLeastJdk16) continue;
                long space = (Long)totalSpaceMethod.invoke((Object)roots[i], new Object[0]);
                props.setProperty(prefix + ".space.total", Long.toString(space));
                space = (Long)freeSpaceMethod.invoke((Object)roots[i], new Object[0]);
                props.setProperty(prefix + ".space.free", Long.toString(space));
                space = (Long)usableSpaceMethod.invoke((Object)roots[i], new Object[0]);
                props.setProperty(prefix + ".space.usable", Long.toString(space));
                continue;
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                    continue;
                }
                log.info(e.getMessage());
            }
        }
        props.setProperty("host.roots.names", sb.toString());
        return props;
    }

    public static synchronized TypedProperties getEnvironment() {
        if (env == null) {
            env = new TypedProperties();
            try {
                Map<String, String> props = System.getenv();
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    env.setProperty(entry.getKey(), entry.getValue());
                }
            }
            catch (SecurityException e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                log.info(e.getMessage());
            }
        }
        return env;
    }

    public static synchronized TypedProperties getNetwork() {
        if (network == null) {
            network = new TypedProperties();
            try {
                network.setProperty("ipv4.addresses", SystemUtils.formatAddresses(NetworkUtils.getIPV4Addresses()));
                network.setProperty("ipv6.addresses", SystemUtils.formatAddresses(NetworkUtils.getIPV6Addresses()));
            }
            catch (SecurityException e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                log.info(e.getMessage());
            }
        }
        return network;
    }

    private static String formatAddresses(List<? extends InetAddress> addresses) {
        StringBuilder sb = new StringBuilder();
        for (InetAddress inetAddress : addresses) {
            String name = inetAddress.getHostName();
            String ip = inetAddress.getHostAddress();
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(name).append('|').append(ip);
        }
        return sb.toString();
    }

    public static long maxFreeHeap() {
        Runtime rt = Runtime.getRuntime();
        return rt.maxMemory() - (rt.totalMemory() - rt.freeMemory());
    }

    private static int determineOSType() {
        String name = System.getProperty("os.name");
        if (StringUtils.startsWithOneOf(name, true, "Linux", "SunOS", "Solaris", "FreeBSD", "OpenBSD")) {
            return 2;
        }
        if (StringUtils.startsWithOneOf(name, true, "Mac", "Darwin")) {
            return 3;
        }
        if (name.startsWith("Windows") && !name.startsWith("Windows CE")) {
            return 1;
        }
        return -1;
    }

    public static boolean isWindows() {
        return OS_TYPE == 1;
    }

    public static boolean isX11() {
        return OS_TYPE == 2;
    }

    public static boolean isMac() {
        return OS_TYPE == 3;
    }

    public static int getPID() {
        int pid = -1;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int idx = name.indexOf(64);
        if (idx >= 0) {
            String sub = name.substring(0, idx);
            try {
                pid = Integer.valueOf(sub);
                if (debugEnabled) {
                    log.debug("process name=" + name + ", pid=" + pid);
                }
            }
            catch (Exception e) {
                String msg = "could not parse '" + sub + "' into a valid integer pid : " + ExceptionUtils.getMessage(e);
                if (debugEnabled) {
                    log.debug(msg, (Throwable)e);
                }
                log.warn(msg);
            }
        }
        return pid;
    }

    public static void addShutdownHook(String key, Thread hook) {
        shutdownHooks.put(key, hook);
        Runtime.getRuntime().addShutdownHook(hook);
    }

    public static void removeShutdownHook(String key) {
        Thread hook = shutdownHooks.remove(key);
        if (hook != null) {
            Runtime.getRuntime().removeShutdownHook(hook);
        }
    }
}

