/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.BufferedReader;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.streams.StreamUtils;

public final class StringUtils {
    public static final Charset UTF_8 = StringUtils.makeUTF8();
    public static final String[] ZERO_STRING = new String[0];
    public static final Object[] ZERO_OBJECT = new Object[0];
    public static final URL[] ZERO_URL = new URL[0];
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StringUtils() {
    }

    public static String padLeft(String source, char padChar, int maxLen) {
        StringBuilder sb = new StringBuilder();
        String src = source == null ? "" : source;
        int length = src.length();
        if (length > maxLen) {
            return source;
        }
        for (int i = 0; i < maxLen - length; ++i) {
            sb.append(padChar);
        }
        sb.append(src);
        return sb.toString();
    }

    public static String padRight(String source, char padChar, int maxLen) {
        String s = source;
        if (s == null) {
            s = "";
        }
        if (s.length() > maxLen) {
            s = s.substring(0, maxLen);
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < maxLen) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String toHexString(byte[] bytes) {
        return StringUtils.toHexString(bytes, 0, bytes.length, null);
    }

    public static String toHexString(byte[] bytes, int start, int length, String sep) {
        StringBuilder sb = new StringBuilder();
        if (length >= 0) {
            boolean sepNotNull = sep != null;
            for (int i = start; i < Math.min(bytes.length, start + length); ++i) {
                if (sepNotNull && i > start) {
                    sb.append(sep);
                }
                byte b = bytes[i];
                sb.append(HEX_DIGITS[(b & 0xF0) >> 4]);
                sb.append(HEX_DIGITS[b & 0xF]);
            }
        }
        return sb.toString();
    }

    public static byte[] toBytes(String hexString) {
        String[] bytes = hexString.split("\\s");
        ArrayList list = new ArrayList(bytes.length);
        byte[] result = new byte[list.size()];
        for (int i = 0; i < bytes.length; ++i) {
            int n = Byte.parseByte(bytes[i].substring(0, 1), 16);
            n = 16 * n + Byte.parseByte(bytes[i].substring(1), 16);
            result[i] = (byte)n;
        }
        return result;
    }

    public static String toStringDuration(long duration) {
        long elapsed = duration;
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.padLeft("" + elapsed / 3600000L, '0', 2)).append(':');
        sb.append(StringUtils.padLeft("" + (elapsed %= 3600000L) / 60000L, '0', 2)).append(':');
        sb.append(StringUtils.padLeft("" + (elapsed %= 60000L) / 1000L, '0', 2)).append('.');
        sb.append(StringUtils.padLeft("" + elapsed % 1000L, '0', 3));
        return sb.toString();
    }

    public static String getRemoteHost(Channel channel) {
        StringBuilder sb = new StringBuilder();
        if (channel instanceof SocketChannel) {
            if (channel.isOpen()) {
                Socket s = ((SocketChannel)channel).socket();
                sb.append(StringUtils.getRemoteHost(s.getRemoteSocketAddress()));
            } else {
                sb.append("[channel closed]");
            }
        } else {
            sb.append("[JVM-local]");
        }
        return sb.toString();
    }

    public static String getRemoteHost(SocketAddress address) {
        StringBuilder sb = new StringBuilder();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress add = (InetSocketAddress)address;
            sb.append(add.getHostName()).append(':').append(add.getPort());
        } else {
            sb.append("socket address type not handled: ").append(address);
        }
        return sb.toString();
    }

    public static <T> String arrayToString(T ... array) {
        return StringUtils.arrayToString(",", "[", "]", array);
    }

    public static <T> String arrayToString(String sep, String prefix, String suffix, T ... array) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            sb.append("null");
        } else {
            if (prefix != null) {
                sb.append(prefix);
            }
            for (int i = 0; i < array.length; ++i) {
                if (i > 0 && sep != null) {
                    sb.append(sep);
                }
                sb.append(array[i]);
            }
            if (suffix != null) {
                sb.append(suffix);
            }
        }
        return sb.toString();
    }

    public static int[] parseIntValues(String s) {
        String[] strPorts = s.split("\\s");
        int[] ports = new int[strPorts.length];
        for (int i = 0; i < strPorts.length; ++i) {
            try {
                int n;
                ports[i] = n = Integer.valueOf(strPorts[i].trim()).intValue();
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return ports;
    }

    public static String buildString(int[] ports) {
        if (ports == null || ports.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ports.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(ports[i]);
        }
        return sb.toString();
    }

    public static String build(Object ... args) {
        if (args == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : args) {
            sb.append(o);
        }
        return sb.toString();
    }

    public static boolean startsWithOneOf(String source, boolean ignoreCase, String ... values) {
        if (source == null || values == null) {
            return false;
        }
        String s = ignoreCase ? source.toLowerCase() : source;
        for (String val : values) {
            String s2;
            if (val == null) continue;
            String string = s2 = ignoreCase ? val.toLowerCase() : val;
            if (!s.startsWith(s2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneOf(String source, boolean ignoreCase, String ... values) {
        if (source == null || values == null) {
            return false;
        }
        String s = ignoreCase ? source.toLowerCase() : source;
        for (String val : values) {
            String s2;
            if (val == null) continue;
            String string = s2 = ignoreCase ? val.toLowerCase() : val;
            if (!s.equals(s2)) continue;
            return true;
        }
        return false;
    }

    public static int[] toIntArray(String source, Pattern separatorPattern) {
        try {
            String[] vals = separatorPattern.split(source);
            int[] result = new int[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                result[i] = Integer.valueOf(vals[i]);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Charset makeUTF8() {
        Charset utf8 = null;
        try {
            utf8 = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            return null;
        }
        return utf8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String indent(String source, String indentation) {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        if (indentation == null) {
            throw new IllegalArgumentException("indentation can't be null");
        }
        boolean endsWithNewline = source.endsWith("\n") || source.endsWith("\r");
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new StringReader(source));
            while ((s = reader.readLine()) != null) {
                sb.append(indentation).append(s).append('\n');
            }
            if (!endsWithNewline) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (reader == null) return sb.toString();
        }
        catch (Exception e) {
            if (reader == null) return sb.toString();
            StreamUtils.closeSilent(reader);
            return sb.toString();
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                StreamUtils.closeSilent(reader);
                throw throwable;
            }
        }
        StreamUtils.closeSilent(reader);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypedProperties toProperties(String source) {
        TypedProperties props = new TypedProperties();
        if (source == null) return props;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(source));
            props.load(reader);
            if (reader == null) return props;
        }
        catch (Exception exception) {
            if (reader == null) return props;
            StreamUtils.closeSilent(reader);
            return props;
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                StreamUtils.closeSilent(reader);
                throw throwable;
            }
        }
        StreamUtils.closeSilent(reader);
        return props;
    }
}

