/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static byte[] writeInt(int value) {
        return SerializationUtils.writeInt(value, new byte[4], 0);
    }

    public static byte[] writeBoolean(boolean value, byte[] data, int offset) {
        data[offset] = value ? (byte)1 : 0;
        return data;
    }

    public static byte[] writeChar(char value, byte[] data, int offset) {
        int pos = offset;
        data[pos++] = (byte)(value >>> 8 & 0xFF);
        data[pos++] = (byte)(value & 0xFF);
        return data;
    }

    public static byte[] writeShort(short value, byte[] data, int offset) {
        int pos = offset;
        data[pos++] = (byte)(value >>> 8 & 0xFF);
        data[pos++] = (byte)(value & 0xFF);
        return data;
    }

    public static byte[] writeInt(int value, byte[] data, int offset) {
        int pos = offset;
        data[pos++] = (byte)(value >>> 24 & 0xFF);
        data[pos++] = (byte)(value >>> 16 & 0xFF);
        data[pos++] = (byte)(value >>> 8 & 0xFF);
        data[pos++] = (byte)(value & 0xFF);
        return data;
    }

    public static byte[] writeLong(long value, byte[] data, int offset) {
        int pos = offset;
        data[pos++] = (byte)(value >>> 56 & 0xFFL);
        data[pos++] = (byte)(value >>> 48 & 0xFFL);
        data[pos++] = (byte)(value >>> 40 & 0xFFL);
        data[pos++] = (byte)(value >>> 32 & 0xFFL);
        data[pos++] = (byte)(value >>> 24 & 0xFFL);
        data[pos++] = (byte)(value >>> 16 & 0xFFL);
        data[pos++] = (byte)(value >>> 8 & 0xFFL);
        data[pos++] = (byte)(value & 0xFFL);
        return data;
    }

    public static void writeInt(int value, OutputStream os) throws IOException {
        os.write((byte)(value >>> 24 & 0xFF));
        os.write((byte)(value >>> 16 & 0xFF));
        os.write((byte)(value >>> 8 & 0xFF));
        os.write((byte)(value & 0xFF));
    }

    public static void writeInt(WritableByteChannel channel, int value) throws IOException {
        int n;
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(value);
        buf.flip();
        for (int count = 0; count < 4; count += n) {
            n = 0;
            while (n == 0) {
                n = channel.write(buf);
            }
            if (n >= 0) continue;
            throw new ClosedChannelException();
        }
    }

    public static int readInt(ReadableByteChannel channel) throws IOException {
        int n;
        ByteBuffer buf = ByteBuffer.allocate(4);
        for (int count = 0; count < 4; count += n) {
            n = 0;
            while (n == 0) {
                n = channel.read(buf);
            }
            if (n >= 0) continue;
            throw new ClosedChannelException();
        }
        buf.flip();
        return buf.getInt();
    }

    public static boolean readBoolean(byte[] data, int offset) {
        return data[offset] != 0;
    }

    public static char readChar(byte[] data, int offset) {
        int pos = offset;
        int result = (data[pos++] & 0xFF) << 8;
        return (char)(result += data[pos++] & 0xFF);
    }

    public static short readShort(byte[] data, int offset) {
        int pos = offset;
        int result = (data[pos++] & 0xFF) << 8;
        return (short)(result += data[pos++] & 0xFF);
    }

    public static int readInt(byte[] data, int offset) {
        int pos = offset;
        int result = (data[pos++] & 0xFF) << 24;
        result += (data[pos++] & 0xFF) << 16;
        result += (data[pos++] & 0xFF) << 8;
        return result += data[pos++] & 0xFF;
    }

    public static long readLong(byte[] data, int offset) {
        int pos = offset;
        long result = (long)(data[pos++] & 0xFF) << 56;
        result += (long)(data[pos++] & 0xFF) << 48;
        result += (long)(data[pos++] & 0xFF) << 40;
        result += (long)(data[pos++] & 0xFF) << 32;
        result += (long)(data[pos++] & 0xFF) << 24;
        result += (long)(data[pos++] & 0xFF) << 16;
        result += (long)(data[pos++] & 0xFF) << 8;
        return result += (long)(data[pos++] & 0xFF);
    }

    public static int readInt(InputStream is) throws IOException {
        int result = (is.read() & 0xFF) << 24;
        result += (is.read() & 0xFF) << 16;
        result += (is.read() & 0xFF) << 8;
        return result += is.read() & 0xFF;
    }

    public static long readLong(InputStream is) throws IOException {
        long result = (long)(is.read() & 0xFF) << 56;
        result += (long)(is.read() & 0xFF) << 48;
        result += (long)(is.read() & 0xFF) << 40;
        result += (long)(is.read() & 0xFF) << 32;
        result += (long)(is.read() & 0xFF) << 24;
        result += (long)(is.read() & 0xFF) << 16;
        result += (long)(is.read() & 0xFF) << 8;
        return result += (long)(is.read() & 0xFF);
    }
}

