/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFErrorReporter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidator {
    private static SchemaFactory sf = null;
    private JPPFErrorReporter reporter = null;

    public static void main(String ... args) {
        try {
            if (args == null || args.length != 2) {
                SchemaValidator.usageAndExit();
            }
            List<String> docPaths = FileUtils.getFilePathList(args[1]);
            for (String path : docPaths) {
                JPPFErrorReporter reporter = new JPPFErrorReporter(path);
                SchemaValidator validator = new SchemaValidator(reporter);
                boolean b = validator.validate(path, args[0]);
                String s = "the document " + path;
                System.out.println(s + (b ? " is valid." : " has errors."));
                if (b) continue;
                System.out.println("fatal errors: " + reporter.allFatalErrorsAsStrings());
                System.out.println("errors      : " + reporter.allErrorsAsStrings());
                System.out.println("warnings    : " + reporter.allWarningsAsStrings());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void usageAndExit() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage:\n\n");
        sb.append("    SchemaValidator <xml schema> <xml document list>\n\n");
        sb.append("Where:\n\n");
        sb.append("  - xml schema is the location of the XML Schema to validate against\n");
        sb.append("  - xml schema is the location of the a text file containing the list\n");
        sb.append("    of XML documents to validate\n\n");
        sb.append("Any file location, including those in the document list, can be either\n");
        sb.append("in the file system or in the classpath.");
        System.out.println(sb.toString());
        System.exit(1);
    }

    public SchemaValidator(JPPFErrorReporter reporter) {
        this.reporter = reporter == null ? new JPPFErrorReporter("Error Reporter") : reporter;
    }

    public Schema loadSchema(String schemaPath) throws IOException, SAXException {
        InputStream is = FileUtils.getFileInputStream(schemaPath);
        if (is == null) {
            return null;
        }
        Schema schema = this.getSchemaFactory().newSchema(new StreamSource(is));
        return schema;
    }

    public Schema loadSchema(InputStream schemaStream) throws IOException, SAXException {
        if (schemaStream == null) {
            return null;
        }
        return this.getSchemaFactory().newSchema(new StreamSource(schemaStream));
    }

    public Schema loadSchema(Reader schemaReader) throws IOException, SAXException {
        if (schemaReader == null) {
            return null;
        }
        return this.getSchemaFactory().newSchema(new StreamSource(schemaReader));
    }

    public boolean validate(String docPath, String schemaPath) throws IOException, SAXException {
        return this.validate(FileUtils.getFileReader(docPath), FileUtils.getFileReader(schemaPath));
    }

    public boolean validate(Reader docReader, Reader schemaReader) throws IOException, SAXException {
        if (docReader == null) {
            return false;
        }
        Schema schema = this.loadSchema(schemaReader);
        if (schema == null) {
            return false;
        }
        Validator validator = schema.newValidator();
        ValidatorErrorHandler handler = new ValidatorErrorHandler(this.reporter);
        validator.setErrorHandler(handler);
        validator.validate(new SAXSource(new InputSource(docReader)));
        return handler.errorCount + handler.fatalCount <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaFactory getSchemaFactory() {
        Class<SchemaValidator> clazz = SchemaValidator.class;
        synchronized (SchemaValidator.class) {
            if (sf == null) {
                sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                sf.setErrorHandler(new ValidatorErrorHandler(null));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sf;
        }
    }

    public String printSAXParseException(SAXParseException e, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("Document ").append(name).append(" at ");
        sb.append(e.getLineNumber()).append(':').append(e.getColumnNumber()).append('\n');
        sb.append(e.getMessage());
        return sb.toString();
    }

    private class ValidatorErrorHandler
    implements ErrorHandler {
        public int errorCount = 0;
        public int fatalCount = 0;
        public int warningCount = 0;
        public JPPFErrorReporter reporter = null;

        public ValidatorErrorHandler(JPPFErrorReporter reporter) {
            this.reporter = reporter == null ? new JPPFErrorReporter("Error Reporter") : reporter;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ++this.errorCount;
            this.reporter.errors.add(SchemaValidator.this.printSAXParseException(exception, this.reporter.name));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ++this.fatalCount;
            this.reporter.fatalErrors.add(SchemaValidator.this.printSAXParseException(exception, this.reporter.name));
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            ++this.warningCount;
            this.reporter.warnings.add(SchemaValidator.this.printSAXParseException(exception, this.reporter.name));
        }
    }
}

