/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

public class Range<T extends Comparable<T>> {
    private T lower;
    private T upper;

    public Range(T value) {
        this(value, value);
    }

    public Range(T lower, T upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public boolean isValueInRange(T value) {
        return this.isValueInRange(value, true);
    }

    public boolean isValueInRange(T value, boolean includeBounds) {
        return includeBounds ? value.compareTo(this.lower) >= 0 && value.compareTo(this.upper) <= 0 : value.compareTo(this.lower) > 0 && value.compareTo(this.upper) < 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.lower);
        if (!this.lower.equals(this.upper)) {
            sb.append(", ").append(this.upper);
        }
        sb.append(']');
        return sb.toString();
    }

    public T getLower() {
        return this.lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public boolean intersects(Range<T> other) {
        return this.intersects(other, true);
    }

    public boolean intersects(Range<T> other, boolean includeBounds) {
        if (other == null) {
            return false;
        }
        return other.isValueInRange(this.lower, includeBounds) || other.isValueInRange(this.upper, includeBounds) || this.includes(other);
    }

    public boolean includes(Range<T> other) {
        if (other == null) {
            return false;
        }
        return other.getLower().compareTo(this.lower) >= 0 && other.getUpper().compareTo(this.upper) <= 0;
    }

    public Range<T> merge(Range<T> other) {
        if (other == null) {
            return new Range<T>(this.getLower(), this.getUpper());
        }
        T minLower = this.lower.compareTo(other.getLower()) <= 0 ? this.lower : other.getLower();
        T maxUpper = this.upper.compareTo(other.getUpper()) >= 0 ? this.upper : other.getUpper();
        return new Range<T>(minLower, maxUpper);
    }

    public Range<T> intersection(Range<T> other) {
        if (other == null || !this.intersects(other)) {
            return null;
        }
        T maxLower = this.lower.compareTo(other.getLower()) >= 0 ? this.lower : other.getLower();
        T minUpper = this.upper.compareTo(other.getUpper()) <= 0 ? this.upper : other.getUpper();
        return new Range<T>(maxLower, minUpper);
    }

    public int hashCode() {
        return 31 + this.lower.hashCode() + 3 * this.upper.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return this.lower.equals(other.lower) && this.upper.equals(other.upper);
    }
}

