/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.Pair;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkUtils {
    private static Logger log = LoggerFactory.getLogger(NetworkUtils.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final Set<String> LOOPBACK_ADDRESSES = NetworkUtils.createLoopbackAddresses();

    private NetworkUtils() {
    }

    public static String getNonLocalHostAddress() {
        List<InetAddress> allAddresses = NetworkUtils.getNonLocalIPV4Addresses();
        return allAddresses.isEmpty() ? null : allAddresses.get(0).getHostAddress();
    }

    public static List<InetAddress> getIPV4Addresses() {
        return NetworkUtils.getIPAddresses(new InetAddressFilter(){

            @Override
            public boolean accepts(InetAddress addr) {
                return addr instanceof Inet4Address;
            }
        });
    }

    public static List<InetAddress> getNonLocalIPV4Addresses() {
        return NetworkUtils.getIPAddresses(new InetAddressFilter(){

            @Override
            public boolean accepts(InetAddress addr) {
                return addr instanceof Inet4Address && !LOOPBACK_ADDRESSES.contains(addr.getHostAddress()) && !"localhost".equals(addr.getHostName());
            }
        });
    }

    public static List<InetAddress> getIPV6Addresses() {
        return NetworkUtils.getIPAddresses(new InetAddressFilter(){

            @Override
            public boolean accepts(InetAddress addr) {
                return addr instanceof Inet6Address;
            }
        });
    }

    public static List<InetAddress> getNonLocalIPV6Addresses() {
        return NetworkUtils.getIPAddresses(new InetAddressFilter(){

            @Override
            public boolean accepts(InetAddress addr) {
                return addr instanceof Inet6Address && !addr.isLoopbackAddress() && !addr.isSiteLocalAddress() && !addr.isLinkLocalAddress() && !"localhost".equals(addr.getHostName());
            }
        });
    }

    private static List<InetAddress> getIPAddresses(InetAddressFilter filter) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                if (debugEnabled && addresses.hasMoreElements()) {
                    log.debug("found network interface: " + ni);
                }
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (filter != null && !filter.accepts(addr)) continue;
                    list.add(addr);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public static List<InetAddress> getNonLocalIPAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        addresses.addAll(NetworkUtils.getNonLocalIPV4Addresses());
        addresses.addAll(NetworkUtils.getNonLocalIPV6Addresses());
        return addresses;
    }

    private static Set<String> createLoopbackAddresses() {
        HashSet<String> addresses = new HashSet<String>();
        String s = "127.0.0.";
        for (int i = 0; i <= 8; ++i) {
            addresses.add(s + i);
        }
        return addresses;
    }

    public static String getManagementHost() {
        TypedProperties props = JPPFConfiguration.getProperties();
        String host = NetworkUtils.getNonLocalHostAddress();
        if (debugEnabled) {
            log.debug("JMX host from NetworkUtils: " + host);
        }
        if (host == null) {
            host = "localhost";
        }
        host = props.getString("jppf.management.host", host);
        if (debugEnabled) {
            log.debug("computed JMX host: " + host);
        }
        return host;
    }

    public static String getHostName(String ip) {
        try {
            InetAddress a = InetAddress.getByName(ip);
            return a.getHostName();
        }
        catch (Exception e) {
            return ip;
        }
    }

    public static int getSubnetMaskLength(InetAddress addr) {
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(addr);
            List<InterfaceAddress> intAddresses = ni.getInterfaceAddresses();
            for (InterfaceAddress ia : intAddresses) {
                if (!addr.equals(ia.getAddress())) continue;
                return ia.getNetworkPrefixLength();
            }
        }
        catch (Exception e) {
            log.error("Error getting subnet mask for address " + addr, (Throwable)e);
        }
        return 0;
    }

    public static List<SubnetInformation> getAllNonLocalSubnetInfo() {
        ArrayList<SubnetInformation> result = new ArrayList<SubnetInformation>();
        List<InetAddress> addresses = NetworkUtils.getNonLocalIPV4Addresses();
        for (InetAddress addr : addresses) {
            int n = NetworkUtils.getSubnetMaskLength(addr);
            result.add(new SubnetInformation(addr, n));
        }
        return result;
    }

    public static boolean isSameSubnet(SubnetInformation si1, SubnetInformation si2) {
        if (!(si1.address() instanceof Inet4Address) || !(si2.address() instanceof Inet4Address)) {
            return false;
        }
        int[] ip = new int[]{si1.rawIPAsInt(), si2.rawIPAsInt()};
        int[] l = new int[]{si1.subnetMaskLength(), si2.subnetMaskLength()};
        int[] mask = new int[]{si1.subnetMask(), si2.subnetMask()};
        int[] n = new int[2];
        for (int i = 0; i < 2; ++i) {
            n[i] = (ip[i] & mask[i]) >> 32 - l[i];
        }
        return n[0] == n[1];
    }

    public static void main(String ... args) {
        System.out.println("This host's ip addresses: " + NetworkUtils.getNonLocalHostAddress());
    }

    public static int[] toIntArray(InetAddress addr) {
        try {
            byte[] bytes = addr.getAddress();
            String ip = addr.getHostAddress();
            int[] result = null;
            if (addr instanceof Inet6Address) {
                result = new int[8];
                int idx = ip.indexOf(37);
                if (idx >= 0) {
                    ip = ip.substring(0, idx);
                }
                String[] comp = ip.split(":");
                for (int i = 0; i < comp.length; ++i) {
                    result[i] = Integer.decode("0x" + comp[i].toLowerCase());
                }
            } else {
                result = new int[4];
                String[] comp = ip.split("\\.");
                for (int i = 0; i < comp.length; ++i) {
                    result[i] = Integer.valueOf(comp[i]);
                }
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isIPv6Address(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            if (addr instanceof Inet6Address && addr.getHostAddress().equals(host)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static class SubnetInformation
    extends Pair<InetAddress, Integer> {
        public SubnetInformation(InetAddress addr, Integer subnetMaskLength) {
            super(addr, subnetMaskLength);
        }

        public InetAddress address() {
            return (InetAddress)this.first();
        }

        public Integer subnetMaskLength() {
            return (Integer)this.second();
        }

        public int rawIPAsInt() {
            byte[] ip = this.address().getAddress();
            int result = ip[0] << 24;
            result &= ip[1] << 16;
            result &= ip[2] << 8;
            return result &= ip[3];
        }

        public int subnetMask() {
            int length = this.subnetMaskLength();
            int mask = length == 0 ? 0 : 1;
            for (int i = 0; i < 32; ++i) {
                mask = mask << 1 & (i < length ? 1 : 0);
            }
            return mask;
        }
    }

    private static interface InetAddressFilter {
        public boolean accepts(InetAddress var1);
    }
}

