/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalizationUtils {
    private static Logger log = LoggerFactory.getLogger(LocalizationUtils.class);

    public static String getLocalized(String baseName, String key) {
        return LocalizationUtils.getLocalized(baseName, key, key);
    }

    public static String[] getLocalized(String baseName, String ... keys) {
        return LocalizationUtils.getLocalized(baseName, Locale.getDefault(), keys);
    }

    public static String[] getLocalized(String baseName, Locale locale, String ... keys) {
        if (keys == null) {
            return new String[0];
        }
        String[] localized = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            localized[i] = LocalizationUtils.getLocalized(baseName, keys[i], keys[i], locale);
        }
        return localized;
    }

    public static String getLocalized(String baseName, String key, String def) {
        return LocalizationUtils.getLocalized(baseName, key, def, Locale.getDefault());
    }

    public static String getLocalized(String baseName, String key, String def, Locale locale) {
        String result;
        block6: {
            if (baseName == null) {
                return def;
            }
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(baseName, locale);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Could not find resource bundle \"" + baseName + '\"', (Throwable)e);
                }
                return def;
            }
            result = null;
            try {
                result = bundle.getString(key);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("Could not find key \"" + key + "\" in resource bundle \"" + baseName + '\"', (Throwable)e);
            }
        }
        return result == null ? def : result;
    }

    public static String getLocalisationBase(String base, String filename) {
        String result = null;
        try {
            File file = new File(filename);
            result = file.getName();
            int idx = result.lastIndexOf(46);
            if (idx >= 0) {
                result = result.substring(0, idx);
            }
            result = base + '/' + result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

