/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.Serializable;
import java.util.Random;

public class JPPFUuid
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String[] ALPHABET_SUPERSET = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "'", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+", "|", "{", "}", "[", "]", "-", "=", "/", ",", ".", "?", ":", ";"};
    public static final char[] ALPHABET_SUPERSET_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\'', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '|', '{', '}', '[', ']', '-', '=', '/', ',', '.', '?', ':', ';'};
    public static final String[] ALPHA_NUM = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String[] HEXADECIMAL = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final char[] HEXADECIMAL_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char[] HEXADECIMAL_UPPER_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Random rand = this.createRandom();
    private String uuid = null;
    private String[] codes = ALPHABET_SUPERSET;
    private char[] codes_char = ALPHABET_SUPERSET_CHAR;
    private int length = 20;

    public JPPFUuid() {
        this.codes_char = HEXADECIMAL_UPPER_CHAR;
        this.length = 36;
        this.uuid = this.generateNormalUuid();
    }

    public JPPFUuid(String[] codes, int length) {
        if (codes != null && codes.length > 0) {
            this.codes = codes;
        }
        if (length > 0) {
            this.length = length;
        }
        this.uuid = this.generateUuid();
    }

    public JPPFUuid(char[] codes, int length) {
        if (codes != null && codes.length > 0) {
            this.codes_char = codes;
        }
        if (length > 0) {
            this.length = length;
        }
        this.uuid = this.generateUuid2();
    }

    private String generateUuid() {
        int len = this.codes.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.codes[this.rand.nextInt(len)]);
        }
        return sb.toString();
    }

    private String generateUuid2() {
        int len = this.codes_char.length;
        StringBuilder sb = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.codes_char[this.rand.nextInt(len)]);
        }
        return sb.toString();
    }

    private String generateNormalUuid() {
        int len = this.codes_char.length;
        char[] uuidChars = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            uuidChars[i] = i == 8 || i == 13 || i == 18 || i == 23 ? 45 : this.codes_char[this.rand.nextInt(len)];
        }
        return new String(uuidChars);
    }

    public String toString() {
        return this.uuid;
    }

    private Random createRandom() {
        return new Random(System.nanoTime());
    }

    public static String normalUUID() {
        return new JPPFUuid().toString();
    }
}

