/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.util.concurrent.TimeUnit;
import org.jppf.utils.Pair;

public class JPPFTimeout
extends Pair<TimeUnit, Long> {
    public JPPFTimeout(TimeUnit unit, Long value) {
        super(unit, value);
        if (unit == null) {
            throw new IllegalArgumentException("Time unit cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Time value cannot be negative");
        }
    }

    public TimeUnit unit() {
        return (TimeUnit)((Object)this.first());
    }

    public Long value() {
        return (Long)this.second();
    }

    public JPPFTimeout convert(TimeUnit newUnit) {
        if (newUnit == null) {
            throw new IllegalArgumentException("Time unit cannot be null");
        }
        long val = newUnit.convert(this.value(), this.unit());
        return new JPPFTimeout(newUnit, val);
    }
}

