/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.utils.ExceptionUtils;

public class JPPFThreadFactory
implements ThreadFactory {
    private static final String THREAD_PREFIX = "-";
    private String name = null;
    private AtomicInteger count = new AtomicInteger(0);
    private boolean monitoringEnabled = false;
    private List<Long> threadIDs = null;
    private long[] threadIDsArray = new long[0];
    private ThreadGroup threadGroup = null;
    private int priority = 5;
    private static ExceptionHandler defaultExceptionHandler = new ExceptionHandler();
    private final boolean doPrivileged;

    public JPPFThreadFactory(String name) {
        this(name, false, 5);
    }

    public JPPFThreadFactory(String name, int priority) {
        this(name, false, priority);
    }

    public JPPFThreadFactory(String name, boolean monitoringEnabled) {
        this(name, monitoringEnabled, 5);
    }

    public JPPFThreadFactory(String name, boolean monitoringEnabled, int priority) {
        this(name, monitoringEnabled, priority, false);
    }

    public JPPFThreadFactory(String name, boolean monitoringEnabled, int priority, boolean doPrivileged) {
        this.name = name == null ? "JPPFThreadFactory" : name;
        this.threadGroup = new ThreadGroup(this.name + " thread group");
        this.threadGroup.setMaxPriority(10);
        this.monitoringEnabled = monitoringEnabled;
        this.priority = priority;
        this.doPrivileged = doPrivileged;
        if (monitoringEnabled) {
            this.threadIDs = new ArrayList<Long>();
        }
    }

    @Override
    public synchronized Thread newThread(final Runnable r) {
        Thread thread = this.doPrivileged ? AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return new Thread(JPPFThreadFactory.this.threadGroup, r, JPPFThreadFactory.this.name + JPPFThreadFactory.THREAD_PREFIX + JPPFThreadFactory.this.incrementCount());
            }
        }) : new Thread(this.threadGroup, r, this.name + THREAD_PREFIX + this.incrementCount());
        if (this.monitoringEnabled) {
            this.threadIDs.add(thread.getId());
            this.computeThreadIDs();
        }
        thread.setPriority(this.priority);
        thread.setUncaughtExceptionHandler(defaultExceptionHandler);
        return thread;
    }

    public synchronized long[] getThreadIDs() {
        return this.threadIDsArray;
    }

    private synchronized void computeThreadIDs() {
        if (!this.monitoringEnabled || this.threadIDs == null || this.threadIDs.isEmpty()) {
            return;
        }
        this.threadIDsArray = new long[this.threadIDs.size()];
        int i = 0;
        for (long id : this.threadIDs) {
            this.threadIDsArray[i++] = id;
        }
    }

    private int incrementCount() {
        return this.count.incrementAndGet();
    }

    public synchronized void updatePriority(int newPriority) {
        if (newPriority < 1 || newPriority > 10 || this.priority == newPriority) {
            return;
        }
        int count = this.threadGroup.activeCount();
        Thread[] threads = new Thread[2 * count];
        int n = this.threadGroup.enumerate(threads);
        for (int i = 0; i < n; ++i) {
            threads[i].setPriority(newPriority);
        }
        this.priority = newPriority;
    }

    public synchronized int getPriority() {
        return this.priority;
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.out.println("exception caught from thread " + t + " :\n" + ExceptionUtils.getStackTrace(e));
        }
    }
}

