/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.IOException;
import java.io.InputStream;
import org.jppf.utils.FileUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFConfiguration {
    private static Logger log = LoggerFactory.getLogger(JPPFConfiguration.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    public static final String CONFIG_PROPERTY = "jppf.config";
    public static final String CONFIG_PLUGIN_PROPERTY = "jppf.config.plugin";
    public static final String DEFAULT_FILE = "jppf.properties";
    private static TypedProperties props = null;

    public static TypedProperties getProperties() {
        if (props == null) {
            JPPFConfiguration.loadProperties();
        }
        return props;
    }

    public static void reset() {
        JPPFConfiguration.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        props = new TypedProperties();
        InputStream is = null;
        try {
            is = JPPFConfiguration.getStream();
            if (is != null) {
                props.load(is);
            }
        }
        catch (Exception e) {
            log.error("error reading the configuration", (Throwable)e);
        }
        finally {
            StreamUtils.close(is, log);
        }
    }

    private static InputStream getStream() throws Exception {
        String altSource = System.getProperty(CONFIG_PLUGIN_PROPERTY);
        String filename = System.getProperty(CONFIG_PROPERTY, DEFAULT_FILE);
        return JPPFConfiguration.getConfigurationStream(filename, altSource);
    }

    public static InputStream getConfigurationStream(String filename, String configurationSourceName) throws Exception {
        InputStream is = null;
        if (configurationSourceName != null) {
            if (log.isDebugEnabled()) {
                log.debug("reading JPPF configuration from config source: " + configurationSourceName);
            }
            ConfigurationSource source = (ConfigurationSource)Class.forName(configurationSourceName).newInstance();
            is = source.getPropertyStream();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("reading JPPF configuration file: " + filename);
            }
            is = FileUtils.getFileInputStream(filename);
        }
        return is;
    }

    public static interface ConfigurationSource {
        public InputStream getPropertyStream() throws IOException;
    }
}

