/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import org.jppf.utils.Pair;

public class HostPort
extends Pair<String, Integer> {
    public HostPort(String host, Integer port) {
        super(host, port);
    }

    public HostPort(String source) {
        String s = source.trim();
        if (s.startsWith("[")) {
            int idx = s.indexOf("]");
            this.first = s.substring(1, idx);
            int port = -1;
            try {
                s = s.substring(idx + 2);
                port = Integer.valueOf(s);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            this.second = port;
        } else {
            String[] comps = s.split(":");
            this.first = comps[0];
            int port = -1;
            try {
                port = Integer.valueOf(comps[1].trim());
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            this.second = port;
        }
    }

    public String host() {
        return (String)this.first();
    }

    public int port() {
        return (Integer)this.second();
    }

    @Override
    public String toString() {
        return this.host() + ':' + this.port();
    }
}

