/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jppf.utils.streams.StreamUtils;

public final class FileUtils {
    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(Reader aReader) throws IOException {
        BufferedReader reader = aReader instanceof BufferedReader ? (BufferedReader)aReader : new BufferedReader(aReader);
        StringBuilder sb = new StringBuilder();
        try {
            String s = "";
            while (s != null) {
                s = reader.readLine();
                if (s == null) continue;
                sb.append(s).append('\n');
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> textFileAsLines(Reader aReader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = aReader instanceof BufferedReader ? (BufferedReader)aReader : new BufferedReader(aReader);
        try {
            String s = "";
            while (s != null) {
                s = reader.readLine();
                if (s == null || "".equals(s.trim())) continue;
                lines.add(s);
            }
        }
        finally {
            reader.close();
        }
        return lines;
    }

    public static String readTextFile(File file) throws IOException {
        return FileUtils.readTextFile(new FileReader(file));
    }

    public static String readTextFile(String filename) throws IOException {
        InputStreamReader reader = null;
        File f = new File(filename);
        if (f.exists()) {
            reader = new FileReader(filename);
        } else {
            InputStream is = FileUtils.class.getClassLoader().getResourceAsStream(filename);
            if (is == null) {
                return null;
            }
            reader = new InputStreamReader(is);
        }
        return FileUtils.readTextFile(reader);
    }

    public static void writeTextFile(String filename, String content) throws IOException {
        FileUtils.writeTextFile(new FileWriter(filename), content);
    }

    public static void writeTextFile(File file, String content) throws IOException {
        FileUtils.writeTextFile(new FileWriter(file), content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(Writer dest, String content) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(content));
        Writer writer = dest instanceof BufferedWriter ? dest : new BufferedWriter(dest);
        try {
            String s = "";
            while (s != null) {
                s = reader.readLine();
                if (s == null) continue;
                writer.write(s);
                writer.write("\n");
            }
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public static InputStream getFileInputStream(String path) throws IOException {
        InputStream is = null;
        File file = new File(path);
        if (file.exists()) {
            is = new BufferedInputStream(new FileInputStream(file));
        }
        if (is == null) {
            is = FileUtils.class.getClassLoader().getResourceAsStream(path);
        }
        return is;
    }

    public static OutputStream getFileOutputStream(String path) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(path));
    }

    public static OutputStream getFileOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static Reader getFileReader(String path) throws IOException {
        InputStream is = FileUtils.getFileInputStream(path);
        if (is == null) {
            return null;
        }
        return new InputStreamReader(is);
    }

    public static Writer getFileWriter(String path) throws IOException {
        return new BufferedWriter(new FileWriter(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFilePathList(String fileListPath) throws IOException {
        InputStream is = FileUtils.getFileInputStream(fileListPath);
        String content = FileUtils.readTextFile(new BufferedReader(new InputStreamReader(is)));
        BufferedReader reader = new BufferedReader(new StringReader(content));
        ArrayList<String> filePaths = new ArrayList<String>();
        try {
            boolean end = false;
            while (!end) {
                String s = reader.readLine();
                if (s != null) {
                    filePaths.add(s);
                    continue;
                }
                end = true;
            }
        }
        finally {
            reader.close();
        }
        return filePaths;
    }

    public static String getFileExtension(String filePath) {
        return FileUtils.getFileExtension(new File(filePath));
    }

    public static String getFileExtension(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        String filePath = null;
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        int idx = filePath.lastIndexOf(46);
        if (idx >= 0) {
            return filePath.substring(idx + 1);
        }
        return null;
    }

    public static String getFileName(String filePath) {
        int idx = FileUtils.getLastFileSeparatorPosition(filePath);
        return idx >= 0 ? filePath.substring(idx + 1) : filePath;
    }

    public static String getParentFolder(String filePath) {
        int idx = FileUtils.getLastFileSeparatorPosition(filePath);
        return idx >= 0 ? filePath.substring(0, idx) : filePath;
    }

    private static int getLastFileSeparatorPosition(String path) {
        int idx1 = path.lastIndexOf(47);
        int idx2 = path.lastIndexOf(92);
        if (idx1 < 0 && idx2 < 0) {
            return -1;
        }
        return idx1 < 0 ? idx2 : (idx2 < 0 ? idx1 : Math.max(idx1, idx2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitTextFile(String file, int splitSize) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        BufferedWriter writer = null;
        int count = 0;
        int size = 0;
        try {
            String s = "";
            while (s != null) {
                if (writer == null) {
                    String name = file + '.' + count;
                    System.out.println("creating file " + name);
                    writer = new BufferedWriter(new FileWriter(name));
                }
                if ((s = reader.readLine()) == null) break;
                writer.write(s + "\n");
                if ((size += s.length()) < splitSize) continue;
                writer.close();
                writer = null;
                ++count;
                size = 0;
            }
            if (writer != null) {
                writer.close();
            }
        }
        finally {
            reader.close();
        }
    }

    public static void main(String ... args) {
        try {
            int size = Integer.valueOf(args[1]);
            FileUtils.splitTextFile(args[0], size);
            System.out.println("Done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] getFileAsByte(String path) throws IOException {
        return FileUtils.getFileAsByte(new File(path));
    }

    public static byte[] getFileAsByte(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        byte[] data = StreamUtils.getInputStreamAsByte(is);
        return data;
    }

    public static File[] toFiles(File dir, String ... names) {
        int len = names.length;
        File[] files = new File[len];
        for (int i = 0; i < len; ++i) {
            files[i] = new File(dir.getPath(), names[i]);
        }
        return files;
    }

    public static URL[] toURLs(File ... files) {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                urls[i] = files[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urls;
    }

    public static void writeBytesToStream(byte[] data, OutputStream os) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamUtils.copyStream(bais, os);
        bais.close();
    }

    public static void writeBytesToFile(byte[] data, String path) throws IOException {
        FileUtils.writeBytesToFile(data, new File(path));
    }

    public static void writeBytesToFile(byte[] data, File path) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path));
        StreamUtils.copyStream(bais, os);
    }

    public static boolean deletePath(File path) {
        if (path == null || !path.exists()) {
            return false;
        }
        boolean success = true;
        try {
            File[] files;
            if (path.isDirectory() && (files = path.listFiles()) != null) {
                for (File child : files) {
                    success &= FileUtils.deletePath(child);
                }
            }
            success &= path.delete();
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    public static void mkdirs(File file) throws IOException {
        File folder;
        File file2 = folder = file.isDirectory() ? file : file.getParentFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("could not create folder " + folder);
        }
    }

    public static URL getURLFromFilePath(String path) {
        File file = new File(path);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL getURLFromFilePath(File path) {
        try {
            return path.toURI().toURL();
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }
}

