/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jppf.utils.collections.AbstractCollectionMap;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Set<T> set(T ... array) {
        HashSet<T> newSet = new HashSet<T>(array.length);
        for (T element : array) {
            newSet.add(element);
        }
        return newSet;
    }

    public static <T> List<T> list(T ... array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T element : array) {
            list.add(element);
        }
        return list;
    }

    public static <T> T[] concatArrays(T[] ... arrays) {
        if (arrays == null) {
            return null;
        }
        int size = 0;
        for (T[] array : arrays) {
            size += array.length;
        }
        ArrayList<T> result = new ArrayList<T>(size);
        T[] tmp = null;
        for (T[] array : arrays) {
            if (array.length <= 0) continue;
            tmp = array;
            break;
        }
        if (tmp == null) {
            return Arrays.copyOf(arrays[0], 0);
        }
        T[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] array;
            for (T t : array = arr$[i$]) {
                result.add(t);
            }
        }
        return result.toArray((Object[])Array.newInstance(tmp[0].getClass(), 0));
    }

    public static <T, U> void putInListMap(T key, U value, Map<T, List<U>> map) {
        List<U> list = map.get(key);
        if (list == null) {
            list = new ArrayList<U>();
            map.put(key, list);
        }
        list.add(value);
    }

    public static <T, U> void removeFromListMap(T key, U value, Map<T, List<U>> map) {
        List<U> list = map.get(key);
        if (list == null) {
            return;
        }
        list.remove(value);
        if (list.isEmpty()) {
            map.remove(key);
        }
    }

    public static <T, U> int sizeOfListMap(Map<T, List<U>> map) {
        int result = 0;
        for (Map.Entry<T, List<U>> entry : map.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public static <T, U> String formatSizeMapInfo(String name, Map<T, List<U>> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("[shallow size=").append(map.size());
        sb.append(", total elements=").append(CollectionUtils.sizeOfListMap(map)).append(']');
        return sb.toString();
    }

    public static <T, U> String formatSizeMapInfo(String name, AbstractCollectionMap<T, U> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("[shallow size=").append(map.size());
        sb.append(", total elements=").append(map.size()).append(']');
        return sb.toString();
    }

    public static <T> List<T> getAllElements(List<T> source, int start, int size) {
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(source.get(i + start));
        }
        return result;
    }
}

