/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.ssl;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.ssl.FileStoreSource;
import org.jppf.ssl.SSLConfigurationException;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLHelper {
    private static Logger log = LoggerFactory.getLogger(SSLHelper.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static TypedProperties sslConfig = null;

    private SSLHelper() {
    }

    public static SSLContext getSSLContext() throws Exception {
        if (sslConfig == null) {
            SSLHelper.loadSSLProperties();
        }
        char[] keyPwd = SSLHelper.getPassword("jppf.ssl.keystore.password");
        KeyStore keyStore = SSLHelper.getStore("jppf.ssl.keystore", keyPwd);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, keyPwd);
        char[] trustPwd = SSLHelper.getPassword("jppf.ssl.truststore.password");
        KeyStore trustStore = SSLHelper.getStore("jppf.ssl.truststore", trustPwd);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(sslConfig.getString("jppf.ssl.context.protocol"));
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    public static SSLParameters getSSLParameters() throws Exception {
        if (sslConfig == null) {
            SSLHelper.loadSSLProperties();
        }
        SSLParameters params = new SSLParameters();
        String s = sslConfig.getString("jppf.ssl.cipher.suites");
        String[] tokens = s == null ? null : s.trim().split("\\s");
        params.setCipherSuites(tokens);
        s = sslConfig.getString("jppf.ssl.protocols");
        tokens = s == null ? null : s.trim().split("\\s");
        params.setProtocols(tokens);
        s = sslConfig.getString("jppf.ssl.client.auth", "none").toLowerCase();
        params.setNeedClientAuth("need".equals(s));
        params.setWantClientAuth("want".equals(s));
        if (debugEnabled) {
            log.debug("SSL parameters : cipher suites=" + StringUtils.arrayToString(params.getCipherSuites()) + ", protocols=" + StringUtils.arrayToString(params.getProtocols()) + ", needCLientAuth=" + params.getNeedClientAuth() + ", wantClientAuth=" + params.getWantClientAuth());
        }
        return params;
    }

    public static SocketWrapper createSSLClientConnection(SocketWrapper socketClient) throws Exception {
        SSLContext context = SSLHelper.getSSLContext();
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)factory.createSocket(socketClient.getSocket(), socketClient.getHost(), socketClient.getPort(), true);
        SSLParameters params = SSLHelper.getSSLParameters();
        sslSocket.setSSLParameters(params);
        sslSocket.setUseClientMode(true);
        ObjectSerializer serializer = socketClient.getSerializer();
        Class<?> clazz = socketClient.getClass();
        Constructor<?> c = clazz.getConstructor(Socket.class);
        SocketWrapper target = (SocketWrapper)c.newInstance(sslSocket);
        target.setSerializer(serializer);
        target.setHost(socketClient.getHost());
        target.setPort(socketClient.getPort());
        return target;
    }

    public static void configureJMXProperties(Map<String, Object> env) throws Exception {
        SSLContext sslContext = SSLHelper.getSSLContext();
        SSLSocketFactory factory = sslContext.getSocketFactory();
        env.put("jmx.remote.profiles", "TLS");
        env.put("jmx.remote.tls.socket.factory", factory);
        SSLParameters params = SSLHelper.getSSLParameters();
        env.put("jmx.remote.tls.enabled.protocols", StringUtils.arrayToString(" ", null, null, params.getProtocols()));
        env.put("jmx.remote.tls.enabled.cipher.suites", StringUtils.arrayToString(" ", null, null, params.getCipherSuites()));
        env.put("jmx.remote.tls.need.client.authentication", "" + params.getNeedClientAuth());
        env.put("jmx.remote.tls.want.client.authentication", "" + params.getWantClientAuth());
    }

    private static KeyStore getKeyOrTrustStore(String filename, char[] pwd) throws Exception {
        return SSLHelper.getKeyOrTrustStore(new FileStoreSource(filename).call(), pwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyOrTrustStore(InputStream is, char[] pwd) throws Exception {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(is, pwd);
        }
        finally {
            StreamUtils.close(is, log);
        }
        return ks;
    }

    private static char[] getPassword(String baseProperty) throws Exception {
        String s = sslConfig.getString(baseProperty, null);
        if (s != null) {
            return s.toCharArray();
        }
        s = sslConfig.getString(baseProperty + ".source", null);
        return (char[])SSLHelper.callSource(s);
    }

    private static KeyStore getStore(String baseProperty, char[] pwd) throws Exception {
        String s = sslConfig.getString(baseProperty + ".file", null);
        if (s != null) {
            return SSLHelper.getKeyOrTrustStore(s, pwd);
        }
        s = sslConfig.getString(baseProperty + ".source", null);
        InputStream is = (InputStream)SSLHelper.callSource(s);
        return SSLHelper.getKeyOrTrustStore(is, pwd);
    }

    private static <E> E callSource(String value) throws Exception {
        if (value == null) {
            return null;
        }
        String[] tokens = value.split("\\s");
        Class<?> clazz = Class.forName(tokens[0]);
        String[] args = null;
        if (tokens.length > 1) {
            args = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, args, 0, args.length);
        }
        Constructor<?> c = null;
        try {
            c = clazz.getConstructor(String[].class);
        }
        catch (NoSuchMethodException ignore) {
            // empty catch block
        }
        Callable callable = c == null ? (Callable)clazz.newInstance() : (Callable)c.newInstance(new Object[]{args});
        return (E)callable.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadSSLProperties() throws Exception {
        if (sslConfig == null) {
            sslConfig = new TypedProperties();
            InputStream is = null;
            TypedProperties config = JPPFConfiguration.getProperties();
            String configSource = config.getString("jppf.ssl.configuration.source", null);
            if (configSource != null) {
                is = (InputStream)SSLHelper.callSource(configSource);
            } else {
                String filename = config.getString("jppf.ssl.configuration.file", null);
                is = FileUtils.getFileInputStream(filename);
            }
            if (is == null) {
                throw new SSLConfigurationException("could not load the SSL configuration");
            }
            try {
                sslConfig.load(is);
            }
            finally {
                StreamUtils.closeSilent(is);
            }
        }
    }
}

