/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLHandler {
    private static Logger log = LoggerFactory.getLogger(SSLHandler.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private SocketChannel channel;
    private SSLEngine sslEngine;
    private SSLEngineResult sslEngineResult = null;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new JPPFThreadFactory("SSLDelegatedTasks"));
    private ByteBuffer applicationSendBuffer;
    private ByteBuffer channelSendBuffer;
    private ByteBuffer applicationReceiveBuffer;
    private ByteBuffer channelReceiveBuffer;

    public SSLHandler(ChannelWrapper<?> channel, SSLEngine sslEngine) throws Exception {
        this.channel = (SocketChannel)((SelectionKey)channel.getChannel()).channel();
        this.sslEngine = sslEngine;
        SSLSession session = sslEngine.getSession();
        this.applicationSendBuffer = ByteBuffer.wrap(new byte[session.getApplicationBufferSize()]);
        this.channelSendBuffer = ByteBuffer.wrap(new byte[session.getPacketBufferSize()]);
        this.applicationReceiveBuffer = ByteBuffer.wrap(new byte[session.getApplicationBufferSize()]);
        this.channelReceiveBuffer = ByteBuffer.wrap(new byte[session.getPacketBufferSize()]);
    }

    public int read() throws Exception {
        int sslCount = 0;
        int count = this.applicationReceiveBuffer.position();
        do {
            this.flush();
            if (this.sslEngine.isInboundDone()) {
                return count > 0 ? count : -1;
            }
            int readCount = this.channel.read(this.channelReceiveBuffer);
            this.channelReceiveBuffer.flip();
            this.sslEngineResult = this.sslEngine.unwrap(this.channelReceiveBuffer, this.applicationReceiveBuffer);
            this.channelReceiveBuffer.compact();
            switch (this.sslEngineResult.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    if (traceEnabled) {
                        log.trace("reading into netRecv=" + this.channelReceiveBuffer);
                    }
                    sslCount = this.channel.read(this.channelReceiveBuffer);
                    if (traceEnabled) {
                        log.trace("sslCount=" + sslCount + ", channelReceiveBuffer=" + this.channelReceiveBuffer);
                    }
                    if (sslCount == 0) {
                        return count;
                    }
                    if (sslCount != -1) break;
                    if (traceEnabled) {
                        log.trace("reached EOF, closing inbound");
                    }
                    this.sslEngine.closeInbound();
                    break;
                }
                case BUFFER_OVERFLOW: {
                    return 0;
                }
                case CLOSED: {
                    this.channel.socket().shutdownInput();
                    break;
                }
                case OK: {
                    count = this.applicationReceiveBuffer.position();
                }
            }
            while (this.processHandshake()) {
            }
        } while ((count = this.applicationReceiveBuffer.position()) == 0);
        if (this.sslEngine.isInboundDone()) {
            count = -1;
        }
        return count;
    }

    public int write() throws Exception {
        if (traceEnabled) {
            log.trace("position=" + this.applicationSendBuffer.position());
        }
        int remaining = this.applicationSendBuffer.position();
        int writeCount = 0;
        if (remaining > 0 && this.flush() > 0) {
            return 0;
        }
        block6: while (remaining > 0) {
            if (traceEnabled) {
                log.trace("before flip/wrap/compact " + this.printSendBuffers() + " count=" + remaining);
            }
            this.applicationSendBuffer.flip();
            this.sslEngineResult = this.sslEngine.wrap(this.applicationSendBuffer, this.channelSendBuffer);
            this.applicationSendBuffer.compact();
            if (traceEnabled) {
                log.trace("after  flip/wrap/compact " + this.printSendBuffers());
            }
            switch (this.sslEngineResult.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    if (traceEnabled) {
                        log.trace("write", (Throwable)new BufferUnderflowException());
                    }
                    throw new BufferUnderflowException();
                }
                case BUFFER_OVERFLOW: {
                    if (traceEnabled) {
                        log.trace("buffer overflow, before flush() channelSendBuffer=" + this.channelSendBuffer);
                    }
                    int flushCount = this.flush();
                    if (traceEnabled) {
                        log.trace("buffer overflow, after  flush() channelSendBuffer=" + this.channelSendBuffer + ", flushCount=" + flushCount);
                    }
                    if (flushCount != 0) continue block6;
                    return 0;
                }
                case CLOSED: {
                    throw new SSLException("outbound closed");
                }
                case OK: {
                    int n = this.sslEngineResult.bytesConsumed();
                    writeCount += n;
                    remaining -= n;
                }
            }
            while (this.processHandshake()) {
            }
        }
        return writeCount;
    }

    public int flush() throws IOException {
        this.channelSendBuffer.flip();
        int n = this.channel.write(this.channelSendBuffer);
        this.channelSendBuffer.compact();
        return n;
    }

    public void close() throws Exception {
        if (!this.sslEngine.isInboundDone() && !this.channel.isBlocking()) {
            this.read();
        }
        while (this.channelSendBuffer.position() > 0) {
            int n = this.flush();
            if (n != 0) continue;
            log.error("unable to flush remaining " + this.channelSendBuffer.remaining() + " bytes");
            break;
        }
        this.sslEngine.closeOutbound();
        if (traceEnabled) {
            log.trace("close outbound handshake");
        }
        while (this.processHandshake()) {
        }
        if (this.channelSendBuffer.position() > 0 && this.flush() == 0) {
            log.error("unable to flush remaining " + this.channelSendBuffer.position() + " bytes");
        }
        if (traceEnabled) {
            log.trace("close outbound done");
        }
        this.channel.close();
        if (traceEnabled) {
            log.trace("SSLEngine closed");
        }
    }

    private void processEngineResult() throws Exception {
        while (this.processEngineResultStatus() && this.processHandshake()) {
        }
    }

    private boolean processHandshake() throws Exception {
        switch (this.sslEngine.getHandshakeStatus()) {
            case NOT_HANDSHAKING: 
            case FINISHED: {
                return false;
            }
            case NEED_TASK: {
                this.performDelegatedTasks();
                return true;
            }
            case NEED_WRAP: {
                this.applicationSendBuffer.flip();
                this.sslEngineResult = this.sslEngine.wrap(this.applicationSendBuffer, this.channelSendBuffer);
                this.applicationSendBuffer.compact();
                if (this.sslEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    int count = this.flush();
                    return count > 0;
                }
                return true;
            }
            case NEED_UNWRAP: {
                this.channelReceiveBuffer.flip();
                this.sslEngineResult = this.sslEngine.unwrap(this.channelReceiveBuffer, this.applicationReceiveBuffer);
                this.channelReceiveBuffer.compact();
                if (this.sslEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    int count = this.sslEngine.isInboundDone() ? -1 : this.channel.read(this.channelReceiveBuffer);
                    if (traceEnabled) {
                        log.trace("readCount=" + count);
                    }
                    return count > 0;
                }
                return this.sslEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        return false;
    }

    boolean processEngineResultStatus() throws Exception {
        if (traceEnabled) {
            log.trace("sslEngineResult=" + this.sslEngineResult);
        }
        switch (this.sslEngineResult.getStatus()) {
            case OK: {
                return true;
            }
            case CLOSED: {
                return this.sslEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
            case BUFFER_OVERFLOW: {
                switch (this.sslEngineResult.getHandshakeStatus()) {
                    case NEED_WRAP: {
                        this.flush();
                        return this.channelSendBuffer.position() == 0;
                    }
                    case NEED_UNWRAP: {
                        if (traceEnabled) {
                            log.trace(this.printBuffers());
                        }
                        return false;
                    }
                }
                return false;
            }
            case BUFFER_UNDERFLOW: {
                if (traceEnabled) {
                    log.trace(this.printBuffers());
                }
                this.flush();
                int count = this.channel.read(this.channelReceiveBuffer);
                if (traceEnabled) {
                    log.trace("underflow: count=" + count + ", channelReceiveBuffer=" + this.channelReceiveBuffer);
                }
                return count > 0;
            }
        }
        return false;
    }

    private void performDelegatedTasks() {
        Runnable delegatedTask;
        while ((delegatedTask = this.sslEngine.getDelegatedTask()) != null) {
            if (traceEnabled) {
                log.trace("running delegated task " + delegatedTask);
            }
            Future<?> f = this.executor.submit(delegatedTask);
            try {
                f.get();
            }
            catch (Exception e) {
                if (traceEnabled) {
                    log.trace(e.getMessage(), (Throwable)e);
                    continue;
                }
                log.warn(ExceptionUtils.getMessage(e));
            }
        }
    }

    public ByteBuffer getApplicationReceiveBuffer() {
        return this.applicationReceiveBuffer;
    }

    public ByteBuffer getApplicationSendBuffer() {
        return this.applicationSendBuffer;
    }

    public ByteBuffer getChannelReceiveBuffer() {
        return this.channelReceiveBuffer;
    }

    public ByteBuffer getChannelSendBuffer() {
        return this.channelSendBuffer;
    }

    private String printBuffers() {
        StringBuilder sb = new StringBuilder();
        sb.append("applicationSendBuffer=").append(this.applicationSendBuffer);
        sb.append(", channelSendBuffer=").append(this.channelSendBuffer);
        sb.append(", applicationReceiveBuffer=").append(this.applicationReceiveBuffer);
        sb.append(", channelReceiveBuffer=").append(this.channelReceiveBuffer);
        return sb.toString();
    }

    private String printSendBuffers() {
        StringBuilder sb = new StringBuilder();
        sb.append("applicationSendBuffer=").append(this.applicationSendBuffer);
        sb.append(", channelSendBuffer=").append(this.channelSendBuffer);
        return sb.toString();
    }
}

