/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.jppf.utils.JPPFConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioConstants {
    static Logger log = LoggerFactory.getLogger(NioConstants.class);
    public static final int THREAD_POOL_SIZE = JPPFConfiguration.getProperties().getInt("transition.thread.pool.size", Runtime.getRuntime().availableProcessors());
    public static final String CLASS_SERVER = "ClassServer";
    public static final String CLIENT_CLASS_SERVER = "ClientClassServer";
    public static final String NODE_CLASS_SERVER = "NodeClassServer";
    public static final String NODE_SERVER = "NodeJobServer";
    public static final String CLIENT_SERVER = "ClientJobServer";
    public static final String ACCEPTOR = "Acceptor";
    public static final long DEFAULT_SELECT_TIMEOUT = JPPFConfiguration.getProperties().getLong("jppf.nio.select.timeout", 1000L);
    public static final boolean CHECK_CONNECTION = NioConstants.getCheckConnection();

    private static boolean getCheckConnection() {
        boolean b = JPPFConfiguration.getProperties().getBoolean("jppf.nio.check.connection", true);
        log.info("NIO checks are " + (b ? "enabled" : "disabled"));
        return b;
    }

    private static int getTransitionManagerPoolSize() {
        int size = JPPFConfiguration.getProperties().getInt("transition.thread.pool.size", -1);
        return size <= 0 ? Runtime.getRuntime().availableProcessors() : size;
    }
}

