/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioMessage;
import org.jppf.server.nio.SSLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNioContext<S extends Enum<S>>
implements NioContext<S> {
    private static Logger log = LoggerFactory.getLogger(AbstractNioContext.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected S state = null;
    protected String uuid = null;
    protected NioMessage message = null;
    protected ChannelWrapper<?> channel = null;
    protected String connectionUuid = null;
    protected SSLHandler sslHandler = null;
    protected boolean peer = false;

    @Override
    public S getState() {
        return this.state;
    }

    @Override
    public void setState(S state) {
        this.state = state;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    protected String getShortClassName() {
        String fqn = this.getClass().getName();
        int idx = fqn.lastIndexOf(46);
        return fqn.substring(idx + 1);
    }

    public NioMessage getMessage() {
        return this.message;
    }

    public void setMessage(NioMessage message) {
        this.message = message;
    }

    @Override
    public ChannelWrapper<?> getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(ChannelWrapper<?> channel) {
        this.channel = channel;
    }

    public String getConnectionUuid() {
        return this.connectionUuid;
    }

    public void setConnectionUuid(String connectionUuid) {
        this.connectionUuid = connectionUuid;
    }

    @Override
    public SSLHandler getSSLHandler() {
        return this.sslHandler;
    }

    @Override
    public void setSSLHandler(SSLHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    public boolean isPeer() {
        return this.peer;
    }

    public void setPeer(boolean peer) {
        this.peer = peer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("channel=").append(this.channel.getClass().getSimpleName()).append("[id=").append(this.channel.getId()).append(']');
        sb.append(", state=").append(this.getState());
        sb.append(", uuid=").append(this.uuid);
        sb.append(", connectionUuid=").append(this.connectionUuid);
        sb.append(", peer=").append(this.peer);
        sb.append(']');
        return sb.toString();
    }
}

