/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.jppf.server.nio.AbstractChannelWrapper;
import org.jppf.server.nio.AbstractNioContext;
import org.jppf.server.nio.NioContext;
import org.jppf.utils.SimpleObjectLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractLocalChannelWrapper<S, T extends AbstractNioContext>
extends AbstractChannelWrapper<T> {
    static Logger log = LoggerFactory.getLogger(AbstractLocalChannelWrapper.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    protected int keyOps = 0;
    protected int readyOps = 0;
    protected S nodeResource = null;
    protected S serverResource = null;
    protected final SimpleObjectLock nodeLock = new SimpleObjectLock();
    protected final SimpleObjectLock serverLock = new SimpleObjectLock();
    protected final SimpleObjectLock opsLock = new SimpleObjectLock();

    public AbstractLocalChannelWrapper(T context) {
        super(context);
        if (traceEnabled) {
            log.trace("created " + this);
        }
    }

    @Override
    public NioContext getContext() {
        return (NioContext)this.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getKeyOps() {
        SimpleObjectLock simpleObjectLock = this.opsLock;
        synchronized (simpleObjectLock) {
            return this.keyOps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeyOps(int keyOps) {
        SimpleObjectLock simpleObjectLock = this.opsLock;
        synchronized (simpleObjectLock) {
            this.keyOps = keyOps;
            if (traceEnabled) {
                log.debug("id=" + this.id + ", readyOps=" + this.readyOps + ", keyOps=" + keyOps);
            }
            if (this.selector != null) {
                this.selector.wakeUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReadyOps() {
        SimpleObjectLock simpleObjectLock = this.opsLock;
        synchronized (simpleObjectLock) {
            return this.readyOps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadyOps(int readyOps) {
        SimpleObjectLock simpleObjectLock = this.opsLock;
        synchronized (simpleObjectLock) {
            this.readyOps = readyOps;
            if (traceEnabled) {
                log.debug("id=" + this.id + ", readyOps=" + readyOps + ", keyOps=" + this.keyOps);
            }
            if (this.selector != null) {
                this.selector.wakeUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelectable() {
        SimpleObjectLock simpleObjectLock = this.opsLock;
        synchronized (simpleObjectLock) {
            return (this.readyOps & this.keyOps) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getNodeResource() {
        SimpleObjectLock simpleObjectLock = this.nodeLock;
        synchronized (simpleObjectLock) {
            return this.nodeResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeResource(S resource) {
        SimpleObjectLock simpleObjectLock = this.nodeLock;
        synchronized (simpleObjectLock) {
            this.nodeResource = resource;
            this.nodeLock.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getServerResource() {
        SimpleObjectLock simpleObjectLock = this.serverLock;
        synchronized (simpleObjectLock) {
            return this.serverResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerResource(S serverResource) {
        SimpleObjectLock simpleObjectLock = this.serverLock;
        synchronized (simpleObjectLock) {
            this.serverResource = serverResource;
            this.serverLock.wakeUp();
        }
    }

    public SimpleObjectLock getNodeLock() {
        return this.nodeLock;
    }

    public SimpleObjectLock getServerLock() {
        return this.serverLock;
    }

    public SimpleObjectLock getOpsLock() {
        return this.opsLock;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(this.getClass().getSimpleName());
        sb.append('[');
        sb.append(this.getStringId());
        sb.append(", readyOps=").append(this.getReadyOps());
        sb.append(", keyOps=").append(this.getKeyOps());
        sb.append(", serverResource=").append(this.serverResource);
        sb.append(", nodeResource=").append(this.serverResource);
        sb.append(", context=").append(this.getContext());
        sb.append(']');
        return sb.toString();
    }
}

