/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.JPPFError;
import org.jppf.serialization.JPPFObjectStreamBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XstreamObjectStreamBuilder
implements JPPFObjectStreamBuilder {
    private static Logger log = LoggerFactory.getLogger(XstreamObjectStreamBuilder.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static ReentrantLock lock = new ReentrantLock();
    private static Method createOisMethod = null;
    private static Method createOosMethod = null;
    private static Object xstream = XstreamObjectStreamBuilder.getXstream();

    @Override
    public ObjectInputStream newObjectInputStream(InputStream in) throws Exception {
        return (ObjectInputStream)createOisMethod.invoke(xstream, in);
    }

    @Override
    public ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return (ObjectOutputStream)createOosMethod.invoke(xstream, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Object getXstream() {
        block6: {
            try {
                if (xstream != null) break block6;
                lock.lock();
                try {
                    if (xstream == null) {
                        Class<?> xstreamClass = Class.forName("com.thoughtworks.xstream.XStream");
                        Class<?> hierarchicalStreamDriverClass = Class.forName("com.thoughtworks.xstream.io.HierarchicalStreamDriver");
                        Class<?> driverClass = Class.forName("com.thoughtworks.xstream.io.xml.XppDriver");
                        Constructor<?> c = xstreamClass.getConstructor(hierarchicalStreamDriverClass);
                        Object o = c.newInstance(driverClass.newInstance());
                        createOisMethod = xstreamClass.getMethod("createObjectInputStream", InputStream.class);
                        createOosMethod = xstreamClass.getMethod("createObjectOutputStream", OutputStream.class);
                        xstream = o;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new JPPFError("A fatal error occurred: " + e.getMessage(), e);
            }
        }
        return xstream;
    }
}

