/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import org.jppf.serialization.ClassDescriptor;
import org.jppf.serialization.FieldDescriptor;
import org.jppf.serialization.ReflectionHelper;
import org.jppf.serialization.SerializationCaches;
import org.jppf.utils.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Serializer {
    static final byte[] HEADER = new byte[]{74, 80, 80, 70};
    static final byte[] NULL_HANDLE = new byte[]{0, 0, 0, 0};
    static final byte CLASS_HEADER = 1;
    static final byte OBJECT_HEADER = 2;
    static final byte NULL_OBJECT_HEADER = 3;
    static final byte CLASS_OBJECT_HEADER = 4;
    private static Logger log = LoggerFactory.getLogger(Serializer.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    ObjectOutputStream out;
    SerializationCaches caches = new SerializationCaches();
    private boolean rootWritten = false;
    ClassDescriptor currentClassDescriptor;
    Object currentObject;
    private byte[] buf = new byte[4096];

    Serializer(ObjectOutputStream out) throws IOException {
        this.out = out;
        out.write(HEADER);
    }

    void writeObject(Object obj) throws Exception {
        if (obj == null) {
            this.out.writeByte(3);
        } else if (obj instanceof Class) {
            this.writeClassObject((Class)obj);
        } else {
            Integer handle = this.caches.objectHandleMap.get(obj);
            if (handle == null) {
                handle = this.caches.newObjectHandle(obj);
                this.writeObject(obj, handle);
            } else {
                this.out.writeByte(2);
                this.out.writeInt(handle);
            }
        }
    }

    private void writeObject(Object obj, int handle) throws Exception {
        HashMap map = new HashMap();
        ClassDescriptor cd = this.caches.getClassDescriptor(obj.getClass(), map);
        this.currentObject = obj;
        this.currentClassDescriptor = cd;
        this.writeClassDescriptors(map);
        map = null;
        this.out.writeByte(2);
        this.out.writeInt(handle);
        this.out.writeInt(cd.handle);
        if (cd.array) {
            this.writeArray(obj, cd);
        } else if (cd.enumType) {
            String name = ((Enum)obj).name();
            this.writeObject(name);
        } else {
            this.writeFields(obj, cd);
        }
    }

    private void writeClassObject(Class obj) throws Exception {
        HashMap map = new HashMap();
        ClassDescriptor cd = this.caches.getClassDescriptor(obj, map);
        this.currentObject = obj;
        this.currentClassDescriptor = cd;
        this.writeClassDescriptors(map);
        this.out.writeByte(4);
        this.out.writeInt(cd.handle);
    }

    void writeFields(Object obj, ClassDescriptor cd) throws Exception {
        ClassDescriptor tmpDesc = cd;
        LinkedBlockingDeque<ClassDescriptor> stack = new LinkedBlockingDeque<ClassDescriptor>();
        while (tmpDesc != null) {
            stack.addFirst(tmpDesc);
            tmpDesc = tmpDesc.superClass;
        }
        for (ClassDescriptor desc : stack) {
            if (desc.hasWriteObject) {
                Method m = ReflectionHelper.getWriteObjectMethod(desc.clazz);
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                m.invoke(obj, this.out);
                continue;
            }
            if (desc.externalizable) {
                ((Externalizable)obj).writeExternal(this.out);
                continue;
            }
            this.writeDeclaredFields(obj, desc);
        }
    }

    void writeDeclaredFields(Object obj, ClassDescriptor cd) throws Exception {
        for (int i = 0; i < cd.fields.length; ++i) {
            FieldDescriptor fd = cd.fields[i];
            if (!fd.field.isAccessible()) {
                fd.field.setAccessible(true);
            }
            Object val = fd.field.get(obj);
            if (fd.type.primitive) {
                switch (fd.type.signature.charAt(0)) {
                    case 'B': {
                        this.out.write((Integer)val);
                        break;
                    }
                    case 'S': {
                        this.out.writeShort(((Short)val).shortValue());
                        break;
                    }
                    case 'I': {
                        this.out.writeInt((Integer)val);
                        break;
                    }
                    case 'J': {
                        this.out.writeLong((Long)val);
                        break;
                    }
                    case 'F': {
                        this.out.writeFloat(((Float)val).floatValue());
                        break;
                    }
                    case 'D': {
                        this.out.writeDouble((Double)val);
                        break;
                    }
                    case 'C': {
                        this.out.writeChar((Integer)val);
                        break;
                    }
                    case 'Z': {
                        this.out.writeBoolean((Boolean)val);
                    }
                }
                continue;
            }
            if (fd.type.enumType) {
                String name = val == null ? null : ((Enum)val).name();
                this.writeObject(name);
                continue;
            }
            this.writeObject(val);
        }
    }

    private void writeArray(Object obj, ClassDescriptor cd) throws Exception {
        int n = Array.getLength(obj);
        this.out.writeInt(n);
        ClassDescriptor eltDesc = cd.componentType;
        if (eltDesc.primitive) {
            switch (eltDesc.signature.charAt(0)) {
                case 'B': {
                    this.out.write((byte[])obj, 0, n);
                    break;
                }
                case 'S': {
                    this.writeShortArray((short[])obj);
                    break;
                }
                case 'I': {
                    this.writeIntArray((int[])obj);
                    break;
                }
                case 'J': {
                    this.writeLongArray((long[])obj);
                    break;
                }
                case 'F': {
                    this.writeFloatArray((float[])obj);
                    break;
                }
                case 'D': {
                    this.writeDoubleArray((double[])obj);
                    break;
                }
                case 'C': {
                    this.writeCharArray((char[])obj);
                    break;
                }
                case 'Z': {
                    this.writeBooleanArray((boolean[])obj);
                }
            }
        } else if (eltDesc.enumType) {
            for (int i = 0; i < n; ++i) {
                Object val = Array.get(obj, i);
                String name = val == null ? null : ((Enum)val).name();
                this.writeObject(name);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Object val = Array.get(obj, i);
                this.writeObject(val);
            }
        }
    }

    private void writeClassDescriptors(Map<Class<?>, ClassDescriptor> map) throws IOException {
        if (map.isEmpty()) {
            return;
        }
        this.out.writeByte(1);
        this.out.writeInt(map.size());
        for (Map.Entry<Class<?>, ClassDescriptor> entry : map.entrySet()) {
            entry.getValue().write(this.out);
        }
    }

    private void writeBooleanArray(boolean[] array) throws Exception {
        int n;
        for (int count = 0; count < array.length; count += n) {
            n = Math.min(this.buf.length, array.length - count);
            for (int i = 0; i < n; ++i) {
                SerializationUtils.writeBoolean(array[count + i], this.buf, i);
            }
            this.out.write(this.buf, 0, n);
        }
    }

    private void writeCharArray(char[] array) throws Exception {
        int n;
        for (int count = 0; count < array.length; count += n) {
            n = Math.min(this.buf.length / 2, array.length - count);
            for (int i = 0; i < n; ++i) {
                SerializationUtils.writeChar(array[count + i], this.buf, 2 * i);
            }
            this.out.write(this.buf, 0, 2 * n);
        }
    }

    private void writeShortArray(short[] array) throws Exception {
        int n;
        for (int count = 0; count < array.length; count += n) {
            n = Math.min(this.buf.length / 2, array.length - count);
            for (int i = 0; i < n; ++i) {
                SerializationUtils.writeShort(array[count + i], this.buf, 2 * i);
            }
            this.out.write(this.buf, 0, 2 * n);
        }
    }

    private void writeIntArray(int[] array) throws Exception {
        int n;
        for (int count = 0; count < array.length; count += n) {
            n = Math.min(this.buf.length / 4, array.length - count);
            for (int i = 0; i < n; ++i) {
                SerializationUtils.writeInt(array[count + i], this.buf, 4 * i);
            }
            this.out.write(this.buf, 0, 4 * n);
        }
    }

    private void writeLongArray(long[] array) throws Exception {
        int n;
        for (int count = 0; count < array.length; count += n) {
            n = Math.min(this.buf.length / 8, array.length - count);
            for (int i = 0; i < n; ++i) {
                SerializationUtils.writeLong(array[count + i], this.buf, 8 * i);
            }
            this.out.write(this.buf, 0, 8 * n);
        }
    }

    private void writeFloatArray(float[] array) throws Exception {
        int n;
        for (int count = 0; count < array.length; count += n) {
            n = Math.min(this.buf.length / 4, array.length - count);
            for (int i = 0; i < n; ++i) {
                SerializationUtils.writeInt(Float.floatToIntBits(array[count + i]), this.buf, 4 * i);
            }
            this.out.write(this.buf, 0, 4 * n);
        }
    }

    private void writeDoubleArray(double[] array) throws Exception {
        int n;
        for (int count = 0; count < array.length; count += n) {
            n = Math.min(this.buf.length / 8, array.length - count);
            for (int i = 0; i < n; ++i) {
                SerializationUtils.writeLong(Double.doubleToLongBits(array[count + i]), this.buf, 8 * i);
            }
            this.out.write(this.buf, 0, 8 * n);
        }
    }
}

