/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.serialization.ClassDescriptor;
import org.jppf.serialization.FieldDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SerializationCaches {
    private static Logger log = LoggerFactory.getLogger(SerializationCaches.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    static final Class<?>[] PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE};
    static Map<Class<?>, ClassDescriptor> globalTypesMap = SerializationCaches.initGlobalTypes();
    Map<Class<?>, ClassDescriptor> classToDescMap = new HashMap();
    Map<Object, Integer> objectHandleMap = new IdentityHashMap<Object, Integer>(256);
    private AtomicInteger classHandleCount = new AtomicInteger(0);
    private AtomicInteger objectHandleCount = new AtomicInteger(0);

    private static Map<Class<?>, ClassDescriptor> initGlobalTypes() {
        IdentityHashMap map = new IdentityHashMap();
        AtomicInteger counter = new AtomicInteger(0);
        try {
            for (Class<?> c : PRIMITIVE_TYPES) {
                SerializationCaches.getClassDescriptorGeneric(c, counter, map, null);
            }
            SerializationCaches.getClassDescriptorGeneric(Object.class, counter, map, null);
            SerializationCaches.getClassDescriptorGeneric(String.class, counter, map, null);
        }
        catch (Exception e) {
            log.error("error initializing global types", (Throwable)e);
        }
        return map;
    }

    SerializationCaches() {
        this.classToDescMap.putAll(globalTypesMap);
        this.classHandleCount.set(this.classToDescMap.size());
    }

    ClassDescriptor getClassDescriptor(Class<?> clazz, Map<Class<?>, ClassDescriptor> map) throws Exception {
        return SerializationCaches.getClassDescriptorGeneric(clazz, this.classHandleCount, this.classToDescMap, map);
    }

    int newObjectHandle(Object o) {
        int handle = this.objectHandleCount.incrementAndGet();
        this.objectHandleMap.put(o, handle);
        if (traceEnabled) {
            try {
                log.trace("created handle " + handle + " for o=" + o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return handle;
    }

    static ClassDescriptor getClassDescriptorGeneric(Class<?> clazz, AtomicInteger counter, Map<Class<?>, ClassDescriptor> map, Map<Class<?>, ClassDescriptor> map2) throws Exception {
        ClassDescriptor cd = map.get(clazz);
        if (cd == null) {
            cd = SerializationCaches.addClassGeneric(clazz, counter, map, map2);
        }
        return cd;
    }

    static ClassDescriptor addClassGeneric(Class<?> clazz, AtomicInteger counter, Map<Class<?>, ClassDescriptor> map, Map<Class<?>, ClassDescriptor> map2) throws Exception {
        ClassDescriptor cd = new ClassDescriptor(clazz);
        cd.handle = counter.incrementAndGet();
        map.put(clazz, cd);
        if (map2 != null) {
            map2.put(clazz, cd);
        }
        for (FieldDescriptor fd : cd.fields) {
            fd.type = SerializationCaches.getClassDescriptorGeneric(fd.field.getType(), counter, map, map2);
        }
        Class<?> tmpClazz = clazz.getSuperclass();
        if (tmpClazz != null && tmpClazz != Object.class) {
            cd.superClass = SerializationCaches.getClassDescriptorGeneric(tmpClazz, counter, map, map2);
        }
        if (clazz.isArray()) {
            cd.componentType = SerializationCaches.getClassDescriptorGeneric(clazz.getComponentType(), counter, map, map2);
        }
        return cd;
    }
}

