/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jppf.JPPFException;
import org.jppf.utils.Pair;
import org.jppf.utils.collections.SoftReferenceValuesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionHelper {
    private static Logger log = LoggerFactory.getLogger(ReflectionHelper.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private static final Byte DEFAULT_BYTE = 0;
    private static final Short DEFAULT_SHORT = 0;
    private static final Integer DEFAULT_INT = 0;
    private static final Long DEFAULT_LONG = 0L;
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    private static final Double DEFAULT_DOUBLE = 0.0;
    private static final Character DEFAULT_CHAR = Character.valueOf('\u0000');
    private static final Boolean DEFAULT_BOOLEAN = Boolean.FALSE;
    private static final Object DEFAULT_REF = null;
    private static Class<?> rfClass = null;
    private static Object rf = null;
    private static Method rfMethod = null;
    private static final Map<Class<?>, Constructor> CONSTRUCTOR_MAP;
    private static final Map<Class<?>, ConstructorWithParameters> DEFAULT_CONSTRUCTOR_MAP;

    public static Field[] getNonTransientFields(Class<?> clazz) throws Exception {
        Field[] allFields = clazz.getDeclaredFields();
        if (allFields.length <= 0) {
            return allFields;
        }
        ArrayList<Field> fields = new ArrayList<Field>(allFields.length);
        for (Field f : allFields) {
            int mod = f.getModifiers();
            if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
            fields.add(f);
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static String getSignatureFromType(Class<?> clazz) throws Exception {
        StringBuilder sb = new StringBuilder();
        Class<?> tmp = clazz;
        while (tmp.isArray()) {
            sb.append('[');
            tmp = tmp.getComponentType();
        }
        if (tmp == Byte.TYPE) {
            sb.append('B');
        } else if (tmp == Short.TYPE) {
            sb.append('S');
        } else if (tmp == Integer.TYPE) {
            sb.append('I');
        } else if (tmp == Long.TYPE) {
            sb.append('J');
        } else if (tmp == Float.TYPE) {
            sb.append('F');
        } else if (tmp == Double.TYPE) {
            sb.append('D');
        } else if (tmp == Boolean.TYPE) {
            sb.append('Z');
        } else if (tmp == Character.TYPE) {
            sb.append('C');
        } else {
            sb.append('L').append(tmp.getName());
        }
        return sb.toString();
    }

    public static Class<?> getNonArrayTypeFromSignature(String signature, ClassLoader cl) throws Exception {
        switch (signature.charAt(0)) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'L': {
                String s = signature.substring(1);
                if ("void".equals(s)) {
                    return Void.TYPE;
                }
                return cl.loadClass(s);
            }
        }
        throw new JPPFException("Could not load type with signature '" + signature + '\'');
    }

    public static Method getWriteObjectMethod(Class<?> clazz) throws Exception {
        Method m = null;
        try {
            m = clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class);
            if (m.getReturnType() != Void.TYPE) {
                return null;
            }
            int n = m.getModifiers();
            return !Modifier.isStatic(n) && Modifier.isPrivate(n) ? m : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getReadObjectMethod(Class<?> clazz) throws Exception {
        Method m = null;
        try {
            m = clazz.getDeclaredMethod("readObject", ObjectInputStream.class);
            if (m.getReturnType() != Void.TYPE) {
                return null;
            }
            int n = m.getModifiers();
            return !Modifier.isStatic(n) && Modifier.isPrivate(n) ? m : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Object initializeRF() {
        try {
            Method m = rfClass.getDeclaredMethod("getReflectionFactory", new Class[0]);
            Object o = m.invoke(null, new Object[0]);
            return o;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Method initializeRFMethod() {
        try {
            Method m = rfClass.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
            return m;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static Object create(Class<?> clazz) throws Exception {
        if (rfMethod == null) {
            return ReflectionHelper.createFromConstructor(clazz);
        }
        return ReflectionHelper.create(clazz, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object create(Class<?> clazz, Class<?> parent) throws Exception {
        try {
            Constructor constructor;
            Map<Class<?>, Constructor> map = CONSTRUCTOR_MAP;
            synchronized (map) {
                constructor = CONSTRUCTOR_MAP.get(clazz);
            }
            if (constructor == null) {
                Constructor<?> superConstructor = parent.getDeclaredConstructor(new Class[0]);
                constructor = (Constructor)rfMethod.invoke(rf, clazz, superConstructor);
                Map<Class<?>, Constructor> map2 = CONSTRUCTOR_MAP;
                synchronized (map2) {
                    CONSTRUCTOR_MAP.put(clazz, constructor);
                }
            }
            return clazz.cast(constructor.newInstance(new Object[0]));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object createFromConstructor(Class<?> clazz) throws Exception {
        ConstructorWithParameters cwp = null;
        Map<Class<?>, ConstructorWithParameters> map = DEFAULT_CONSTRUCTOR_MAP;
        synchronized (map) {
            cwp = DEFAULT_CONSTRUCTOR_MAP.get(clazz);
        }
        if (cwp == null) {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            Arrays.sort(constructors, new ConstructorComparator());
            for (Constructor<?> c : constructors) {
                Class<?>[] paramTypes = c.getParameterTypes();
                Object[] params = new Object[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    params[i] = ReflectionHelper.defaultValue(paramTypes[i]);
                }
                if (!c.isAccessible()) {
                    c.setAccessible(true);
                }
                try {
                    Object result = c.newInstance(params);
                    cwp = new ConstructorWithParameters(c, params);
                    Map<Class<?>, ConstructorWithParameters> map2 = DEFAULT_CONSTRUCTOR_MAP;
                    synchronized (map2) {
                        DEFAULT_CONSTRUCTOR_MAP.put(clazz, cwp);
                    }
                    return result;
                }
                catch (Throwable t) {
                    log.info(t.getMessage(), t);
                }
            }
        } else {
            return ((Constructor)cwp.first()).newInstance((Object[])cwp.second());
        }
        throw new InstantiationException("Could not create an instance of " + clazz);
    }

    private static Object defaultValue(Class<?> c) {
        if (c == Byte.TYPE || c == Byte.class) {
            return DEFAULT_BYTE;
        }
        if (c == Short.TYPE || c == Short.class) {
            return DEFAULT_SHORT;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return DEFAULT_INT;
        }
        if (c == Long.TYPE || c == Long.class) {
            return DEFAULT_LONG;
        }
        if (c == Float.TYPE || c == Float.class) {
            return DEFAULT_FLOAT;
        }
        if (c == Double.TYPE || c == Double.class) {
            return DEFAULT_DOUBLE;
        }
        if (c == Character.TYPE || c == Character.class) {
            return DEFAULT_CHAR;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return DEFAULT_BOOLEAN;
        }
        return DEFAULT_REF;
    }

    static {
        try {
            rfClass = Class.forName("sun.reflect.ReflectionFactory");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rfClass != null && (rf = ReflectionHelper.initializeRF()) != null) {
            rfMethod = ReflectionHelper.initializeRFMethod();
        }
        CONSTRUCTOR_MAP = new SoftReferenceValuesMap();
        DEFAULT_CONSTRUCTOR_MAP = new SoftReferenceValuesMap();
    }

    private static class ConstructorWithParameters
    extends Pair<Constructor<?>, Object[]> {
        ConstructorWithParameters(Constructor<?> constructor, Object ... params) {
            super(constructor, params);
        }
    }

    private static class ConstructorComparator
    implements Comparator<Constructor<?>>,
    Serializable {
        private ConstructorComparator() {
        }

        @Override
        public int compare(Constructor<?> c1, Constructor<?> c2) {
            int n2;
            int n1 = c1.getParameterTypes().length;
            return n1 < (n2 = c2.getParameterTypes().length) ? -1 : (n1 > n2 ? 1 : 0);
        }
    }
}

