/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.jppf.serialization.JPPFPutField;
import org.jppf.serialization.Serializer;
import org.jppf.utils.SerializationUtils;

public class JPPFObjectOutputStream
extends ObjectOutputStream {
    private DataOutputStream out;
    private boolean writingObject = false;
    private Serializer serializer = null;
    private final byte[] buf = new byte[8];
    private ObjectOutputStream.PutField currentPutField = null;

    public JPPFObjectOutputStream(OutputStream out) throws IOException {
        this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        this.serializer = new Serializer(this);
    }

    @Override
    protected final void writeObjectOverride(Object obj) throws IOException {
        boolean alreadyWriting = this.writingObject;
        try {
            if (!alreadyWriting) {
                this.writingObject = true;
            }
            this.serializer.writeObject(obj);
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e.getMessage(), e);
        }
        finally {
            if (!alreadyWriting) {
                this.writingObject = false;
                this.flush();
            }
        }
    }

    @Override
    public void write(int val) throws IOException {
        this.out.write(val);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.out.writeBoolean(val);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.out.writeByte(val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.out.writeShort(val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.out.writeChar(val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        SerializationUtils.writeInt(val, this.buf, 0);
        this.out.write(this.buf, 0, 4);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.out.writeLong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.out.writeFloat(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.out.writeLong(Double.doubleToLongBits(val));
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.out.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.out.writeChars(str);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }

    @Override
    public void defaultWriteObject() throws IOException {
        try {
            this.serializer.writeDeclaredFields(this.serializer.currentObject, this.serializer.currentClassDescriptor);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.currentPutField == null) {
            this.currentPutField = new JPPFPutField(this);
        }
        return this.currentPutField;
    }

    @Override
    public void writeFields() throws IOException {
        try {
            JPPFPutField f = (JPPFPutField)this.currentPutField;
            this.writeFields0(f.primitiveFields);
            this.writeFields0(f.objectFields);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    private void writeFields0(Map<String, Object> map) throws Exception {
        int n = map.size();
        String[] names = new String[n];
        Object[] values = new Object[n];
        int count = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            names[count] = entry.getKey();
            values[count] = entry.getValue();
            ++count;
        }
        this.serializer.writeObject(names);
        this.serializer.writeObject(values);
    }
}

