/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.jppf.serialization.Deserializer;
import org.jppf.serialization.JPPFGetField;

public class JPPFObjectInputStream
extends ObjectInputStream {
    private DataInputStream in;
    private Deserializer deserializer;
    private boolean readingObject = false;
    private final byte[] buf = new byte[8];

    public JPPFObjectInputStream(InputStream in) throws IOException {
        this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        this.deserializer = new Deserializer(this);
    }

    @Override
    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        Object o = null;
        boolean alreadyReading = this.readingObject;
        try {
            if (!alreadyReading) {
                this.readingObject = true;
            }
            o = this.deserializer.readObject();
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (!alreadyReading) {
                this.readingObject = false;
            }
        }
        return o;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.in.read(buf, off, len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public int skipBytes(int len) throws IOException {
        return this.in.skipBytes(len);
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.in.readFully(buf);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        this.in.readFully(buf, off, len);
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        try {
            this.deserializer.readDeclaredFields(this.deserializer.currentClassDescriptor, this.deserializer.currentObject);
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        try {
            JPPFGetField getFields = new JPPFGetField();
            this.readFields0(getFields.primitiveFields);
            this.readFields0(getFields.objectFields);
            return getFields;
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    private void readFields0(Map<String, Object> map) throws Exception {
        String[] names = (String[])this.deserializer.readObject();
        Object[] values = (Object[])this.deserializer.readObject();
        for (int i = 0; i < names.length; ++i) {
            map.put(names[i], values[i]);
        }
    }
}

