/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.jppf.serialization.JPPFObjectStreamBuilder;

public class JPPFConfigurationObjectStreamBuilder
implements JPPFObjectStreamBuilder {
    private Class<?> oisClass = null;
    private Class<?> oosClass = null;
    private Constructor<?> oisConstructor = null;
    private Constructor<?> oosConstructor = null;

    public JPPFConfigurationObjectStreamBuilder() throws Exception {
        this.oisClass = ObjectInputStream.class;
        this.oosClass = ObjectOutputStream.class;
        this.initializeConstructors();
    }

    public JPPFConfigurationObjectStreamBuilder(Class<?> oisClass, Class<?> oosClass) throws Exception {
        this.oisClass = oisClass;
        this.oosClass = oosClass;
        this.initializeConstructors();
    }

    public JPPFConfigurationObjectStreamBuilder(String oisClassName, String oosClassName) throws Exception {
        this(Class.forName(oisClassName), Class.forName(oosClassName));
    }

    private void initializeConstructors() throws Exception {
        this.oisConstructor = this.oisClass.getConstructor(InputStream.class);
        this.oosConstructor = this.oosClass.getConstructor(OutputStream.class);
    }

    @Override
    public ObjectInputStream newObjectInputStream(InputStream in) throws Exception {
        return (ObjectInputStream)this.oisConstructor.newInstance(in);
    }

    @Override
    public ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return (ObjectOutputStream)this.oosConstructor.newInstance(out);
    }
}

