/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import org.jppf.serialization.ClassDescriptor;
import org.jppf.serialization.DeserializationCaches;
import org.jppf.serialization.FieldDescriptor;
import org.jppf.serialization.ReflectionHelper;
import org.jppf.serialization.Serializer;
import org.jppf.utils.SerializationUtils;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Deserializer {
    private static Logger log = LoggerFactory.getLogger(Deserializer.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    ObjectInputStream in;
    DeserializationCaches caches = new DeserializationCaches();
    ClassLoader classloader = this.initClassLoader();
    int currentHandle;
    ClassDescriptor currentClassDescriptor;
    Object currentObject;
    private byte[] buf = new byte[4096];

    Deserializer(ObjectInputStream in) throws IOException {
        this.in = in;
        this.readToBuf(4);
        if (this.buf[0] != Serializer.HEADER[0] || this.buf[1] != Serializer.HEADER[1] || this.buf[2] != Serializer.HEADER[2] || this.buf[3] != Serializer.HEADER[3]) {
            throw new IOException("bad header: " + StringUtils.toHexString(this.buf, 0, 4, " "));
        }
    }

    Object readObject() throws Exception {
        byte b = this.in.readByte();
        while (b == 1) {
            this.readClassDescriptors();
            b = this.in.readByte();
        }
        if (b == 3) {
            return null;
        }
        if (b == 4) {
            return this.readClassObject();
        }
        int handle = this.in.readInt();
        Object o = this.caches.handleToObjectMap.get(handle);
        if (o != null) {
            return o;
        }
        this.readObject(handle);
        return this.caches.handleToObjectMap.get(handle);
    }

    private void readObject(int handle) throws Exception {
        int cdHandle = this.in.readInt();
        ClassDescriptor cd = this.caches.getDescriptor(cdHandle);
        if (cd.array) {
            this.readArray(handle, cd);
        } else if (cd.enumType) {
            String name = (String)this.readObject();
            Object val = name == null ? null : (Object)Enum.valueOf(cd.clazz, name);
            this.caches.handleToObjectMap.put(handle, val);
        } else {
            Object obj;
            this.currentObject = obj = this.newInstance(cd);
            this.currentClassDescriptor = cd;
            this.caches.handleToObjectMap.put(handle, obj);
            this.readFields(cd, obj);
        }
    }

    private Object readClassObject() throws Exception {
        int cdHandle = this.in.readInt();
        ClassDescriptor cd = this.caches.getDescriptor(cdHandle);
        return cd.clazz;
    }

    void readFields(ClassDescriptor cd, Object obj) throws Exception {
        ClassDescriptor tmpDesc = cd;
        LinkedBlockingDeque<ClassDescriptor> stack = new LinkedBlockingDeque<ClassDescriptor>();
        while (tmpDesc != null) {
            stack.addFirst(tmpDesc);
            tmpDesc = this.caches.getDescriptor(tmpDesc.superClassHandle);
        }
        for (ClassDescriptor desc : stack) {
            if (desc.hasWriteObject) {
                Method m = ReflectionHelper.getReadObjectMethod(desc.clazz);
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                m.invoke(obj, this.in);
                continue;
            }
            if (desc.externalizable) {
                ((Externalizable)obj).readExternal(this.in);
                continue;
            }
            this.readDeclaredFields(desc, obj);
        }
    }

    void readDeclaredFields(ClassDescriptor cd, Object obj) throws Exception {
        for (int i = 0; i < cd.fields.length; ++i) {
            FieldDescriptor fd = cd.fields[i];
            ClassDescriptor typeDesc = this.caches.getDescriptor(fd.typeHandle);
            Field field = cd.clazz.getDeclaredField(fd.name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (typeDesc.primitive) {
                switch (typeDesc.signature.charAt(0)) {
                    case 'B': {
                        field.setByte(obj, (byte)this.in.read());
                        break;
                    }
                    case 'S': {
                        field.setShort(obj, this.in.readShort());
                        break;
                    }
                    case 'I': {
                        field.setInt(obj, this.in.readInt());
                        break;
                    }
                    case 'J': {
                        field.setLong(obj, this.in.readLong());
                        break;
                    }
                    case 'F': {
                        field.setFloat(obj, this.in.readFloat());
                        break;
                    }
                    case 'D': {
                        field.setDouble(obj, this.in.readDouble());
                        break;
                    }
                    case 'C': {
                        field.setChar(obj, this.in.readChar());
                        break;
                    }
                    case 'Z': {
                        field.setBoolean(obj, this.in.readBoolean());
                    }
                }
                continue;
            }
            if (typeDesc.enumType) {
                String name = (String)this.readObject();
                Object val = name == null ? null : Enum.valueOf(typeDesc.clazz, name);
                field.set(obj, val);
                continue;
            }
            Object val = this.readObject();
            field.set(obj, val);
        }
    }

    private void readArray(int handle, ClassDescriptor cd) throws Exception {
        int len = this.in.readInt();
        ClassDescriptor eltDesc = this.caches.getDescriptor(cd.componentTypeHandle);
        Object obj = null;
        if (eltDesc.primitive) {
            switch (eltDesc.signature.charAt(0)) {
                case 'B': {
                    obj = this.readByteArray(len);
                    break;
                }
                case 'S': {
                    obj = this.readShortArray(len);
                    break;
                }
                case 'I': {
                    obj = this.readIntArray(len);
                    break;
                }
                case 'J': {
                    obj = this.readLongArray(len);
                    break;
                }
                case 'F': {
                    obj = this.readFloatArray(len);
                    break;
                }
                case 'D': {
                    obj = this.readDoubleArray(len);
                    break;
                }
                case 'C': {
                    obj = this.readCharArray(len);
                    break;
                }
                case 'Z': {
                    obj = this.readBooleanArray(len);
                }
            }
            this.caches.handleToObjectMap.put(handle, obj);
        } else if (eltDesc.enumType) {
            obj = Array.newInstance(eltDesc.clazz, len);
            this.caches.handleToObjectMap.put(handle, obj);
            for (int i = 0; i < len; ++i) {
                String name = (String)this.readObject();
                Object val = name == null ? null : Enum.valueOf(eltDesc.clazz, name);
                Array.set(obj, i, val);
            }
        } else {
            obj = Array.newInstance(eltDesc.clazz, len);
            this.caches.handleToObjectMap.put(handle, obj);
            for (int i = 0; i < len; ++i) {
                Object ref = this.readObject();
                Array.set(obj, i, ref);
            }
        }
    }

    private void readClassDescriptors() throws Exception {
        int n = this.in.readInt();
        ArrayList<ClassDescriptor> list = new ArrayList<ClassDescriptor>(n > 0 ? n : 10);
        for (int i = 0; i < n; ++i) {
            ClassDescriptor cd = new ClassDescriptor();
            cd.read(this.in);
            this.caches.handleToDescriptorMap.put(cd.handle, cd);
            list.add(cd);
            if (!traceEnabled) continue;
            try {
                log.trace("read " + cd);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.caches.initializeDescriptorClasses(list, this.classloader);
    }

    private ClassLoader initClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl != null ? cl : this.getClass().getClassLoader();
    }

    private Object newInstance(ClassDescriptor cd) throws Exception {
        return ReflectionHelper.create(cd.clazz);
    }

    private byte[] readByteArray(int len) throws Exception {
        int n;
        byte[] array = new byte[len];
        for (int count = 0; count < len; count += n) {
            n = Math.min(this.buf.length, len - count);
            this.readToBuf(n);
            System.arraycopy(this.buf, 0, array, count, n);
        }
        return array;
    }

    private boolean[] readBooleanArray(int len) throws Exception {
        int n;
        boolean[] array = new boolean[len];
        for (int count = 0; count < len; count += n) {
            n = Math.min(this.buf.length, len - count);
            this.readToBuf(n);
            for (int i = 0; i < n; ++i) {
                array[count + i] = this.buf[i] != 0;
            }
        }
        return array;
    }

    private char[] readCharArray(int len) throws Exception {
        int n;
        char[] array = new char[len];
        for (int count = 0; count < len; count += n) {
            n = Math.min(this.buf.length / 2, len - count);
            this.readToBuf(2 * n);
            for (int i = 0; i < n; ++i) {
                array[count + i] = SerializationUtils.readChar(this.buf, 2 * i);
            }
        }
        return array;
    }

    private short[] readShortArray(int len) throws Exception {
        int n;
        short[] array = new short[len];
        for (int count = 0; count < len; count += n) {
            n = Math.min(this.buf.length / 2, len - count);
            this.readToBuf(2 * n);
            for (int i = 0; i < n; ++i) {
                array[count + i] = SerializationUtils.readShort(this.buf, 2 * i);
            }
        }
        return array;
    }

    private int[] readIntArray(int len) throws Exception {
        int n;
        int[] array = new int[len];
        for (int count = 0; count < len; count += n) {
            n = Math.min(this.buf.length / 4, len - count);
            this.readToBuf(4 * n);
            for (int i = 0; i < n; ++i) {
                array[count + i] = SerializationUtils.readInt(this.buf, 4 * i);
            }
        }
        return array;
    }

    private long[] readLongArray(int len) throws Exception {
        int n;
        long[] array = new long[len];
        for (int count = 0; count < len; count += n) {
            n = Math.min(this.buf.length / 8, len - count);
            this.readToBuf(8 * n);
            for (int i = 0; i < n; ++i) {
                array[count + i] = SerializationUtils.readLong(this.buf, 8 * i);
            }
        }
        return array;
    }

    private float[] readFloatArray(int len) throws Exception {
        int n;
        float[] array = new float[len];
        for (int count = 0; count < len; count += n) {
            n = Math.min(this.buf.length / 4, len - count);
            this.readToBuf(4 * n);
            for (int i = 0; i < n; ++i) {
                array[count + i] = Float.intBitsToFloat(SerializationUtils.readInt(this.buf, 4 * i));
            }
        }
        return array;
    }

    private double[] readDoubleArray(int len) throws Exception {
        int n;
        double[] array = new double[len];
        for (int count = 0; count < len; count += n) {
            n = Math.min(this.buf.length / 8, len - count);
            this.readToBuf(8 * n);
            for (int i = 0; i < n; ++i) {
                array[count + i] = Double.longBitsToDouble(SerializationUtils.readLong(this.buf, 8 * i));
            }
        }
        return array;
    }

    private void readToBuf(int len) throws IOException {
        int pos = 0;
        while (pos < len) {
            int n = this.in.read(this.buf, pos, len - pos);
            if (n > 0) {
                pos += n;
                continue;
            }
            if (n >= 0) continue;
            throw new EOFException("could only read " + pos + " bytes out of " + len);
        }
    }
}

