/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jppf.serialization.ClassDescriptor;
import org.jppf.serialization.FieldDescriptor;
import org.jppf.serialization.ReflectionHelper;
import org.jppf.serialization.SerializationCaches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeserializationCaches {
    private static Logger log = LoggerFactory.getLogger(DeserializationCaches.class);
    Map<Integer, ClassDescriptor> handleToDescriptorMap = new HashMap<Integer, ClassDescriptor>();
    Map<Integer, Object> handleToObjectMap = new HashMap<Integer, Object>();

    DeserializationCaches() {
        Set<Map.Entry<Class<?>, ClassDescriptor>> entries = SerializationCaches.globalTypesMap.entrySet();
        ArrayList<ClassDescriptor> list = new ArrayList<ClassDescriptor>(entries.size());
        for (Map.Entry<Class<?>, ClassDescriptor> entry : entries) {
            ClassDescriptor cd = entry.getValue();
            ClassDescriptor cd2 = new ClassDescriptor();
            cd2.signature = cd.signature;
            cd2.primitive = cd.primitive;
            cd2.array = cd.array;
            cd2.externalizable = cd.externalizable;
            cd2.hasWriteObject = cd.hasWriteObject;
            cd2.enumType = cd.enumType;
            cd2.handle = cd.handle;
            if (cd.superClass != null) {
                cd2.superClassHandle = cd.superClass.handle;
            }
            if (cd.componentType != null) {
                cd2.componentTypeHandle = cd.componentType.handle;
            }
            if (cd.fields.length > 0) {
                cd2.fields = new FieldDescriptor[cd.fields.length];
                for (int i = 0; i < cd.fields.length; ++i) {
                    FieldDescriptor fd = cd.fields[i];
                    FieldDescriptor fd2 = new FieldDescriptor();
                    fd2.name = fd.name;
                    if (fd.type != null) {
                        fd2.typeHandle = fd.type.handle;
                    }
                    cd2.fields[i] = fd2;
                }
            }
            this.handleToDescriptorMap.put(cd2.handle, cd2);
            list.add(cd2);
        }
        try {
            this.initializeDescriptorClasses(list, this.getClass().getClassLoader());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    ClassDescriptor getDescriptor(int handle) {
        return this.handleToDescriptorMap.get(handle);
    }

    void initializeDescriptorClasses(Collection<ClassDescriptor> list, ClassLoader classloader) throws Exception {
        for (ClassDescriptor cd : list) {
            if (cd.clazz != null) continue;
            if (cd.array) {
                ArrayList<ClassDescriptor> types = new ArrayList<ClassDescriptor>();
                ClassDescriptor tmp = cd;
                while (tmp != null) {
                    types.add(tmp);
                    tmp = tmp.array ? this.getDescriptor(tmp.componentTypeHandle) : null;
                }
                for (int i = types.size() - 1; i >= 0; --i) {
                    tmp = (ClassDescriptor)types.get(i);
                    if (tmp.clazz != null) continue;
                    if (!tmp.array) {
                        tmp.clazz = ReflectionHelper.getNonArrayTypeFromSignature(tmp.signature, classloader);
                        continue;
                    }
                    Class<?> clazz = ((ClassDescriptor)types.get((int)(i + 1))).clazz;
                    Object array = Array.newInstance(clazz, 0);
                    tmp.clazz = array.getClass();
                }
                continue;
            }
            cd.clazz = ReflectionHelper.getNonArrayTypeFromSignature(cd.signature, classloader);
        }
    }
}

