/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jppf.serialization.FieldDescriptor;
import org.jppf.serialization.ReflectionHelper;

class ClassDescriptor {
    static final FieldDescriptor[] NO_FIELDS = new FieldDescriptor[0];
    static final byte PRIMITIVE = 1;
    static final byte ARRAY = 2;
    static final byte ENUM_TYPE = 4;
    static final byte HAS_WRITE_OBJECT = 8;
    static final byte EXTERNALIZABLE = 16;
    FieldDescriptor[] fields = NO_FIELDS;
    boolean hasWriteObject = false;
    byte flags = 0;
    Method writeObjectMethod;
    boolean externalizable = false;
    boolean array;
    boolean primitive;
    boolean enumType;
    String signature;
    Class<?> clazz;
    int handle = 0;
    ClassDescriptor superClass;
    int superClassHandle;
    ClassDescriptor componentType;
    int componentTypeHandle;

    ClassDescriptor() {
    }

    ClassDescriptor(Class<?> clazz) throws Exception {
        this.clazz = clazz;
        this.primitive = clazz.isPrimitive();
        this.enumType = clazz.isEnum();
        if (!this.primitive && !this.enumType) {
            Field[] refFields;
            this.externalizable = Externalizable.class.isAssignableFrom(clazz);
            this.writeObjectMethod = ReflectionHelper.getWriteObjectMethod(clazz);
            this.hasWriteObject = this.writeObjectMethod != null;
            this.array = clazz.isArray();
            if (!this.array && (refFields = ReflectionHelper.getNonTransientFields(clazz)).length > 0) {
                this.fields = new FieldDescriptor[refFields.length];
                for (int i = 0; i < refFields.length; ++i) {
                    this.fields[i] = new FieldDescriptor(refFields[i]);
                }
            }
        }
        this.signature = ReflectionHelper.getSignatureFromType(clazz).intern();
    }

    void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.handle);
        out.writeUTF(this.signature);
        this.flags = 0;
        if (this.primitive) {
            this.flags = (byte)(this.flags | 1);
        }
        if (this.enumType) {
            this.flags = (byte)(this.flags | 4);
        }
        if (this.hasWriteObject) {
            this.flags = (byte)(this.flags | 8);
        }
        if (this.externalizable) {
            this.flags = (byte)(this.flags | 0x10);
        }
        if (this.array) {
            this.flags = (byte)(this.flags | 2);
        }
        out.writeByte(this.flags);
        out.writeInt(this.superClass != null ? this.superClass.handle : 0);
        if (this.array) {
            out.writeInt(this.componentType.handle);
        }
        if (!this.primitive) {
            out.writeInt(this.fields.length);
            for (FieldDescriptor field : this.fields) {
                field.write(out);
            }
        }
    }

    void read(ObjectInputStream in) throws IOException {
        this.handle = in.readInt();
        this.signature = in.readUTF();
        this.flags = in.readByte();
        this.primitive = (this.flags & 1) != 0;
        this.enumType = (this.flags & 4) != 0;
        this.hasWriteObject = (this.flags & 8) != 0;
        this.externalizable = (this.flags & 0x10) != 0;
        this.array = (this.flags & 2) != 0;
        this.superClassHandle = in.readInt();
        if (this.array) {
            this.componentTypeHandle = in.readInt();
        }
        if (!this.primitive) {
            int n = in.readInt();
            this.fields = new FieldDescriptor[n];
            for (int i = 0; i < n; ++i) {
                this.fields[i] = new FieldDescriptor();
                this.fields[i].read(in);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("handle=").append(this.handle).append(", ");
        sb.append("signature=").append(this.signature).append(", ");
        sb.append("primitive=").append(this.primitive).append(", ");
        sb.append("hasWriteObject=").append(this.hasWriteObject).append(", ");
        sb.append("externalizable=").append(this.externalizable).append(", ");
        sb.append("array=").append(this.array).append(", ");
        if (this.superClassHandle > 0) {
            sb.append("superClassHandle=").append(this.superClassHandle).append(", ");
        }
        if (this.superClass != null) {
            sb.append("superClass=").append(this.superClass.signature).append(", ");
        }
        if (this.componentTypeHandle > 0) {
            sb.append("componentTypeHandle=").append(this.componentTypeHandle).append(", ");
        }
        if (this.componentType != null) {
            sb.append("componentType=").append(this.componentType.signature).append(", ");
        }
        sb.append("fields={");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.fields[i]);
        }
        sb.append('}');
        return sb.toString();
    }
}

