/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanPermission;
import javax.management.MBeanServerPermission;
import javax.management.ObjectName;
import org.jppf.security.JPPFPermissions;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PermissionsFactory {
    private static Logger log = LoggerFactory.getLogger(PermissionsFactory.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static List<Permission> permList = null;
    private static JPPFPermissions normalPermissions = null;
    private static JPPFPermissions extendedPermissions = null;

    private PermissionsFactory() {
    }

    public static synchronized void resetPermissions() {
        permList = null;
    }

    public static synchronized PermissionCollection getPermissions(ClassLoader classLoader) {
        if (permList == null) {
            ClassLoader cl = classLoader == null ? PermissionsFactory.class.getClassLoader() : classLoader;
            PermissionsFactory.createPermissions(cl);
            if (debugEnabled) {
                log.debug("created normal permissions");
            }
        }
        if (debugEnabled) {
            log.debug("getting normal permissions");
        }
        return normalPermissions;
    }

    public static synchronized PermissionCollection getExtendedPermissions(ClassLoader classLoader) {
        if (permList == null) {
            ClassLoader cl = classLoader == null ? PermissionsFactory.class.getClassLoader() : classLoader;
            PermissionsFactory.createPermissions(cl);
            if (debugEnabled) {
                log.debug("created extended permissions");
            }
        }
        if (debugEnabled) {
            log.debug("getting extended permissions");
        }
        return extendedPermissions;
    }

    private static synchronized void createPermissions(ClassLoader classLoader) {
        if (permList != null) {
            return;
        }
        permList = new ArrayList<Permission>();
        PermissionsFactory.createDynamicPermissions();
        PermissionsFactory.createManagementPermissions();
        PermissionsFactory.readStaticPermissions(classLoader);
        normalPermissions = new JPPFPermissions();
        extendedPermissions = new JPPFPermissions();
        for (Permission p : permList) {
            normalPermissions.add(p);
            extendedPermissions.add(p);
        }
        extendedPermissions.add(new RuntimePermission("exitVM"));
        extendedPermissions.add(new RuntimePermission("setSecurityManager"));
    }

    private static void createDynamicPermissions() {
        try {
            TypedProperties props = JPPFConfiguration.getProperties();
            String host = props.getString("jppf.server.host", "localhost");
            int port = props.getAndReplaceInt("jppf.server.port", "class.server.port", 11111, false);
            PermissionsFactory.addPermission(new SocketPermission(host + ':' + port, "connect,listen"), "dynamic");
            host = props.getString("jppf.discovery.group", "230.0.0.1");
            PermissionsFactory.addPermission(new SocketPermission(host + ":0-", "accept,connect,listen,resolve"), "dynamic");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void createManagementPermissions() {
        try {
            TypedProperties props = JPPFConfiguration.getProperties();
            int port = props.getInt("jppf.management.port", 11198);
            int rmiPort = props.getInt("jppf.management.rmi.port", 12198);
            PermissionsFactory.addPermission(new SocketPermission("localhost:" + port, "accept,connect,listen,resolve"), "management");
            PermissionsFactory.addPermission(new SocketPermission("localhost:" + rmiPort, "accept,connect,listen,resolve"), "management");
            PermissionsFactory.addPermission(new MBeanServerPermission("*"), "management");
            PermissionsFactory.addPermission(new MBeanPermission("*", "*", new ObjectName("*:*"), "*"), "management");
            PermissionsFactory.addPermission(new SocketPermission("*:1024-", "accept,connect,listen,resolve"), "management");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readStaticPermissions(ClassLoader classLoader) {
        InputStream is = null;
        LineNumberReader reader = null;
        try {
            String line;
            String file;
            block17: {
                file = JPPFConfiguration.getProperties().getString("jppf.policy.file");
                if (file == null) {
                    return;
                }
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    if (!debugEnabled) break block17;
                    log.debug("jppf policy file '" + file + "' not found locally");
                }
            }
            if (is == null) {
                is = classLoader.getResourceAsStream(file);
            }
            if (is == null) {
                if (debugEnabled) {
                    log.debug("jppf policy file '" + file + "' not found on the driver side");
                }
                return;
            }
            reader = new LineNumberReader(new InputStreamReader(is));
            int count = 0;
            boolean end = false;
            while (!end && (line = reader.readLine()) != null) {
                ++count;
                if ("".equals(line = line.trim()) || line.startsWith("//")) continue;
                if (!line.startsWith("permission")) {
                    PermissionsFactory.err(file, count, " should start with \"permission\"");
                    continue;
                }
                if ((line = line.substring("permission".length())).contains("PropertyPermission")) {
                    String breakpoint = "pause here";
                }
                if (!line.endsWith(";")) {
                    PermissionsFactory.err(file, count, " should end with \";\"");
                    continue;
                }
                line = line.substring(0, line.length() - 1);
                Permission p = PermissionsFactory.parsePermission(line = line.trim(), file, count);
                if (p == null) continue;
                PermissionsFactory.addPermission(p, "static");
            }
            StreamUtils.closeSilent(reader);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            StreamUtils.closeSilent(reader);
        }
    }

    private static void addPermission(Permission p, String type) throws Exception {
        if (debugEnabled) {
            log.debug("adding " + type + " permission: " + p);
        }
        permList.add(p);
    }

    private static Permission parsePermission(String source, String file, int line) {
        int idx2;
        String className = null;
        String name = null;
        String actions = null;
        int idx = source.indexOf(34);
        if (idx < 0) {
            PermissionsFactory.err(file, line, "permission entry has no name/action, or missing opening quote");
            return null;
        }
        className = source.substring(0, idx).trim();
        if ((idx2 = source.indexOf(34, ++idx)) < 0) {
            PermissionsFactory.err(file, line, "missing closing quote on permission name");
            return null;
        }
        name = source.substring(idx, idx2);
        idx = source.indexOf(34, idx2 + 1);
        if (idx >= 0) {
            if ((idx2 = source.indexOf(34, ++idx)) < 0) {
                PermissionsFactory.err(file, line, "missing closing quote on permission action");
                return null;
            }
            actions = source.substring(idx, idx2);
        }
        if ((name = PermissionsFactory.expandProperties(name, file, line)) == null) {
            return null;
        }
        if (actions != null && (actions = PermissionsFactory.expandProperties(actions, file, line)) == null) {
            return null;
        }
        return PermissionsFactory.instantiatePermission(className, name, actions, file, line);
    }

    private static Permission instantiatePermission(String className, String name, String actions, String file, int line) {
        Permission permission = null;
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return new UnresolvedPermission(className, name, actions, null);
        }
        Constructor<?> constructor = null;
        Object[] params = null;
        ReflectiveOperationException ex = null;
        String msg = null;
        try {
            if (actions != null) {
                constructor = c.getConstructor(String.class, String.class);
                params = new Object[]{name, actions};
            } else {
                constructor = c.getConstructor(String.class);
                params = new Object[]{name};
            }
            permission = (Permission)constructor.newInstance(params);
        }
        catch (InstantiationException e) {
            ex = e;
            msg = "could not instantiate";
        }
        catch (IllegalAccessException e) {
            ex = e;
            msg = "could not instantiate";
        }
        catch (InvocationTargetException e) {
            ex = e;
            msg = "could not instantiate";
        }
        catch (NoSuchMethodException e) {
            ex = e;
            msg = "could not find a proper constructor for";
        }
        if (ex != null) {
            msg = msg + " permission with class=\"" + className + "\", name=\"" + name + "\", actions=\"" + actions + "\" [" + ex.getMessage() + "]";
            PermissionsFactory.err(file, line, msg);
            return null;
        }
        return permission;
    }

    private static String expandProperties(String source, String file, int line) {
        StringBuilder sb = new StringBuilder();
        int length = source.length();
        int pos = 0;
        while (pos < length) {
            int idx = source.indexOf("${", pos);
            if (idx < 0) {
                if (pos > length - 1) break;
                sb.append(source.substring(pos));
                break;
            }
            if (idx > pos) {
                sb.append(source.substring(pos, idx));
            }
            if ((idx = source.indexOf(125, pos = idx + 2)) < 0) {
                PermissionsFactory.err(file, line, "missing closing \"}\" on property expansion");
                return null;
            }
            String s = source.substring(pos, idx);
            if (s == null) {
                return source;
            }
            if ("".equals(s = s.trim())) {
                return source;
            }
            String value = System.getProperty(s);
            if (value == null) {
                return source;
            }
            sb.append(value);
            pos = idx + 1;
        }
        return sb.toString();
    }

    private static void err(String file, int line, String msg) {
        System.err.println("Policy file '" + file + "', line " + line + " : " + msg);
    }
}

