/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.security;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import org.jppf.classloader.JPPFClassLoader;
import org.jppf.security.PermissionsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFPolicy
extends Policy {
    private static Logger log = LoggerFactory.getLogger(JPPFPolicy.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private ClassLoader classLoader = null;

    public JPPFPolicy(ClassLoader classLoader) {
        this.classLoader = classLoader;
        PermissionsFactory.getPermissions(classLoader);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        ClassLoader cl;
        if (debugEnabled) {
            log.debug("in getPermissions(CodeSource) : " + JPPFPolicy.toString(codesource));
        }
        if ((cl = Thread.currentThread().getContextClassLoader()) == this.classLoader || !(cl instanceof JPPFClassLoader)) {
            return PermissionsFactory.getExtendedPermissions(this.classLoader);
        }
        return PermissionsFactory.getPermissions(this.classLoader);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        ClassLoader cl;
        if (debugEnabled) {
            log.debug("in getPermissions(ProtectionDomain) : " + JPPFPolicy.toString(domain));
        }
        if ((cl = domain.getClassLoader()) == this.classLoader || !(cl instanceof JPPFClassLoader)) {
            return PermissionsFactory.getExtendedPermissions(this.classLoader);
        }
        return PermissionsFactory.getPermissions(this.classLoader);
    }

    @Override
    public void refresh() {
    }

    private static String toString(CodeSource code) {
        if (code == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder().append("location = ").append(code.getLocation());
        return sb.toString();
    }

    private static String toString(ProtectionDomain domain) {
        StringBuilder sb = new StringBuilder().append("class loader = ").append(domain.getClassLoader());
        sb.append(", code source = [").append(JPPFPolicy.toString(domain.getCodeSource())).append(']');
        return sb.toString();
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        RuntimePermission rp;
        String action;
        if (debugEnabled && permission instanceof RuntimePermission && (action = (rp = (RuntimePermission)permission).getActions()) != null && action.contains("exitVM")) {
            log.debug("in implies(exitVM)", (Throwable)new Exception());
        }
        return super.implies(domain, permission);
    }
}

