/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.scheduling;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.scheduling.JPPFSchedule;
import org.jppf.utils.JPPFThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFScheduleHandler {
    private static Logger log = LoggerFactory.getLogger(JPPFScheduleHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private ScheduledExecutorService executor;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private Map<Object, ScheduledFuture<?>> futureMap = new Hashtable();
    private String name = null;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public JPPFScheduleHandler() {
        this("JPPFScheduleHandler timer - " + instanceCount.incrementAndGet());
    }

    public JPPFScheduleHandler(String name) {
        this.name = name;
        this.createExecutor();
    }

    public void scheduleAction(Object key, JPPFSchedule schedule, Runnable action) throws ParseException {
        this.scheduleAction(key, schedule, action, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAction(Object key, JPPFSchedule schedule, Runnable action, long start) throws ParseException {
        if (debugEnabled) {
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                log.debug(this.name + " : scheduling action[key=" + key + ", " + schedule + ", action=" + action + ", start=" + this.sdf.format(new Date(start)));
            }
        }
        Date date = schedule.toDate(start);
        ScheduledFuture<?> future = this.executor.schedule(action, date.getTime() - start, TimeUnit.MILLISECONDS);
        this.futureMap.put(key, future);
        if (debugEnabled) {
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                log.debug(this.name + " : date=" + this.sdf.format(date) + ", key=" + key + ", future=" + future);
            }
        }
    }

    public void cancelAction(Object key) {
        if (key == null) {
            return;
        }
        ScheduledFuture<?> future = this.futureMap.remove(key);
        if (debugEnabled) {
            log.debug(this.name + " : cancelling action for key=" + key + ", future=" + future);
        }
        if (future != null) {
            future.cancel(true);
        }
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean shutdown) {
        for (Map.Entry<Object, ScheduledFuture<?>> entry : this.futureMap.entrySet()) {
            ScheduledFuture<?> f = entry.getValue();
            if (f == null) continue;
            f.cancel(true);
        }
        this.futureMap.clear();
        if (shutdown) {
            this.executor.shutdownNow();
        }
    }

    private void createExecutor() {
        this.executor = Executors.newScheduledThreadPool(1, new JPPFThreadFactory(this.name));
        if (debugEnabled) {
            log.debug("created executor with name=" + this.name);
        }
    }
}

