/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.jppf.node.event.NodeLifeCycleEvent;
import org.jppf.node.event.NodeLifeCycleListener;
import org.jppf.node.screensaver.NodePanel;
import org.jppf.node.screensaver.NodeThread;

class NodeState
implements NodeLifeCycleListener {
    public NodeThread nodeThread = null;
    public AtomicInteger taskCount = new AtomicInteger(0);
    public boolean[][] status = new boolean[2][2];
    public JLabel[][] statusLabels = new JLabel[2][2];
    public JLabel countLabel = null;
    public JLabel timeLabel = null;
    public JButton[] btn = new JButton[2];
    public boolean startedOnce = false;
    public long startedAt = System.currentTimeMillis();

    public NodeState() {
        for (int i = 0; i < this.statusLabels.length; ++i) {
            this.statusLabels[i][0] = new JLabel(NodePanel.DARK_GREEN);
            this.statusLabels[i][1] = new JLabel(NodePanel.BRIGHT_RED);
        }
        Dimension d = new Dimension(8, 8);
        JLabel[][] arr$ = this.statusLabels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JLabel[] statusLabel;
            for (JLabel aStatusLabel : statusLabel = arr$[i$]) {
                aStatusLabel.setMinimumSize(d);
                aStatusLabel.setMaximumSize(d);
                aStatusLabel.setBackground(Color.BLACK);
            }
        }
        this.countLabel = new JLabel("" + this.taskCount);
        d = new Dimension(60, 20);
        this.countLabel.setMinimumSize(d);
        this.countLabel.setMaximumSize(d);
        this.countLabel.setBackground(Color.BLACK);
        this.countLabel.setForeground(Color.WHITE);
        this.timeLabel = new JLabel("Active for: " + NodePanel.toStringDuration(0L));
        this.timeLabel.setBackground(Color.BLACK);
        this.timeLabel.setForeground(Color.WHITE);
        this.nodeThread = new NodeThread(this);
        this.btn[0] = new JButton("Start");
        this.btn[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeState.this.startNode();
            }
        });
        this.btn[1] = new JButton("Stop");
        this.btn[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeState.this.stopNode();
            }
        });
        this.btn[1].setEnabled(false);
    }

    public void startNode() {
        this.btn[0].setEnabled(false);
        this.btn[1].setEnabled(true);
        if (!this.startedOnce) {
            this.startedOnce = true;
            this.nodeThread.start();
        } else {
            this.nodeThread.startNode();
        }
    }

    public void stopNode() {
        this.btn[0].setEnabled(true);
        this.btn[1].setEnabled(false);
        this.nodeThread.stopNode();
    }

    @Override
    public void nodeStarting(NodeLifeCycleEvent event) {
        this.statusLabels[0][0].setIcon(NodePanel.BRIGHT_GREEN);
        this.statusLabels[0][1].setIcon(NodePanel.DARK_RED);
        this.statusLabels[1][0].setIcon(NodePanel.DARK_GREEN);
        this.statusLabels[1][1].setIcon(NodePanel.BRIGHT_RED);
    }

    @Override
    public void nodeEnding(NodeLifeCycleEvent event) {
        this.statusLabels[0][0].setIcon(NodePanel.DARK_GREEN);
        this.statusLabels[0][1].setIcon(NodePanel.BRIGHT_RED);
        this.statusLabels[1][0].setIcon(NodePanel.DARK_GREEN);
        this.statusLabels[1][1].setIcon(NodePanel.DARK_RED);
    }

    @Override
    public void jobStarting(NodeLifeCycleEvent event) {
        this.statusLabels[1][0].setIcon(NodePanel.BRIGHT_GREEN);
        this.statusLabels[1][1].setIcon(NodePanel.DARK_RED);
    }

    @Override
    public void jobEnding(NodeLifeCycleEvent event) {
        this.statusLabels[1][0].setIcon(NodePanel.DARK_GREEN);
        this.statusLabels[1][1].setIcon(NodePanel.BRIGHT_RED);
    }
}

