/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.policy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jppf.JPPFException;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.node.policy.PolicyBuilder;
import org.jppf.node.policy.PolicyDescriptor;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFErrorReporter;
import org.jppf.utils.SchemaValidator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PolicyParser {
    private static final List<String> RULE_NAMES = Arrays.asList("NOT", "AND", "OR", "XOR", "LessThan", "AtMost", "AtLeast", "MoreThan", "BetweenII", "BetweenIE", "BetweenEI", "BetweenEE", "Equal", "Contains", "OneOf", "RegExp", "CustomRule");
    private DocumentBuilder parser = null;

    public PolicyParser() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.parser = dbf.newDocumentBuilder();
    }

    public PolicyDescriptor parse(String docPath) throws Exception {
        InputStream is = FileUtils.getFileInputStream(docPath);
        if (is == null) {
            return null;
        }
        Document doc = this.parser.parse(is);
        return this.generateTree(this.findFirstElement(doc));
    }

    public PolicyDescriptor parse(Reader reader) throws Exception {
        InputSource is = new InputSource(reader);
        Document doc = this.parser.parse(is);
        return this.generateTree(this.findFirstElement(doc));
    }

    private Node findFirstElement(Document doc) {
        NodeList list = doc.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            return node;
        }
        return null;
    }

    private PolicyDescriptor generateTree(Node node) {
        PolicyDescriptor desc = new PolicyDescriptor();
        desc.type = node.getNodeName();
        NamedNodeMap attrMap = node.getAttributes();
        Node attrNode = attrMap.getNamedItem("valueType");
        if (attrNode != null) {
            desc.valueType = attrNode.getNodeValue();
        }
        if ((attrNode = attrMap.getNamedItem("ignoreCase")) != null) {
            desc.ignoreCase = attrNode.getNodeValue();
        }
        if ((attrNode = attrMap.getNamedItem("class")) != null) {
            desc.className = attrNode.getNodeValue();
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 1) continue;
            String name = childNode.getNodeName();
            if (RULE_NAMES.contains(name)) {
                desc.children.add(this.generateTree(childNode));
                continue;
            }
            if ("Property".equals(name) || "Value".equals(name)) {
                desc.operands.add(this.getTextNodeValue(childNode));
                continue;
            }
            if (!"Arg".equals(name)) continue;
            desc.arguments.add(this.getTextNodeValue(childNode));
        }
        return desc;
    }

    private String getTextNodeValue(Node node) {
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node childNode = children.item(j);
            short type = childNode.getNodeType();
            if (type != 3 && type != 4) continue;
            return childNode.getNodeValue();
        }
        return null;
    }

    public static void main(String ... args) {
        try {
            String docPath = "ExecutionPolicy.xml";
            JPPFErrorReporter reporter = new JPPFErrorReporter(docPath);
            String schemaPath = "org/jppf/schemas/ExecutionPolicy.xsd";
            SchemaValidator validator = new SchemaValidator(reporter);
            if (!validator.validate(docPath, schemaPath)) {
                String s = "the document " + docPath;
                System.out.println(s + " has errors.");
                System.out.println("fatal errors: " + reporter.allFatalErrorsAsStrings());
                System.out.println("errors      : " + reporter.allErrorsAsStrings());
                System.out.println("warnings    : " + reporter.allWarningsAsStrings());
                return;
            }
            PolicyParser parser = new PolicyParser();
            PolicyDescriptor desc = parser.parse(docPath);
            ExecutionPolicy policy = new PolicyBuilder().buildPolicy(desc.children.get(0));
            System.out.println("Successfully build policy object:\n" + policy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ExecutionPolicy parsePolicy(String policyContent) throws Exception {
        return PolicyParser.parsePolicy(new StringReader(policyContent));
    }

    public static ExecutionPolicy parsePolicyFile(String docPath) throws Exception {
        return PolicyParser.parsePolicy(FileUtils.getFileReader(docPath));
    }

    public static ExecutionPolicy parsePolicy(File policyFile) throws Exception {
        return PolicyParser.parsePolicy(new BufferedReader(new FileReader(policyFile)));
    }

    public static ExecutionPolicy parsePolicy(InputStream stream) throws Exception {
        return PolicyParser.parsePolicy(new InputStreamReader(stream));
    }

    public static ExecutionPolicy parsePolicy(Reader reader) throws Exception {
        PolicyDescriptor desc = new PolicyParser().parse(reader);
        return new PolicyBuilder().buildPolicy(desc.children.get(0));
    }

    public static void validatePolicy(String policyContent) throws JPPFException, Exception {
        PolicyParser.validatePolicy(FileUtils.getFileReader(policyContent));
    }

    public static void validatePolicyFile(String docPath) throws JPPFException, Exception {
        PolicyParser.validatePolicy(FileUtils.getFileReader(docPath));
    }

    public static void validatePolicy(File docPath) throws JPPFException, Exception {
        PolicyParser.validatePolicy(new BufferedReader(new FileReader(docPath)));
    }

    public static void validatePolicy(InputStream stream) throws JPPFException, Exception {
        PolicyParser.validatePolicy(new InputStreamReader(stream));
    }

    public static void validatePolicy(Reader reader) throws JPPFException, Exception {
        JPPFErrorReporter reporter = new JPPFErrorReporter("XML validator");
        SchemaValidator validator = new SchemaValidator(reporter);
        String schemaPath = "org/jppf/schemas/ExecutionPolicy.xsd";
        if (!validator.validate(reader, FileUtils.getFileReader(schemaPath))) {
            StringBuilder sb = new StringBuilder();
            sb.append("The XML document has errors:\n");
            if (!reporter.fatalErrors.isEmpty()) {
                sb.append("fatal errors: ").append(reporter.allFatalErrorsAsStrings()).append('\n');
            }
            if (!reporter.errors.isEmpty()) {
                sb.append("errors      : ").append(reporter.allErrorsAsStrings()).append('\n');
            }
            if (!reporter.warnings.isEmpty()) {
                sb.append("warnings    : ").append(reporter.allWarningsAsStrings()).append('\n');
            }
            throw new JPPFException(sb.toString());
        }
    }
}

