/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.policy;

import org.jppf.node.policy.AtLeast;
import org.jppf.node.policy.AtMost;
import org.jppf.node.policy.BetweenEE;
import org.jppf.node.policy.BetweenEI;
import org.jppf.node.policy.BetweenIE;
import org.jppf.node.policy.BetweenII;
import org.jppf.node.policy.Contains;
import org.jppf.node.policy.CustomPolicy;
import org.jppf.node.policy.Equal;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.node.policy.LessThan;
import org.jppf.node.policy.MoreThan;
import org.jppf.node.policy.OneOf;
import org.jppf.node.policy.PolicyDescriptor;
import org.jppf.node.policy.RegExp;

public class PolicyBuilder {
    public ExecutionPolicy buildPolicy(PolicyDescriptor desc) throws Exception {
        String type = desc.type;
        if ("NOT".equals(type)) {
            return this.buildNotPolicy(desc);
        }
        if ("AND".equals(type)) {
            return this.buildAndPolicy(desc);
        }
        if ("OR".equals(type)) {
            return this.buildOrPolicy(desc);
        }
        if ("XOR".equals(type)) {
            return this.buildXorPolicy(desc);
        }
        if ("LessThan".equals(type)) {
            return this.buildLessThanPolicy(desc);
        }
        if ("MoreThan".equals(type)) {
            return this.buildMoreThanPolicy(desc);
        }
        if ("AtMost".equals(type)) {
            return this.buildAtMostPolicy(desc);
        }
        if ("AtLeast".equals(type)) {
            return this.buildAtLeastPolicy(desc);
        }
        if ("BetweenII".equals(type)) {
            return this.buildBetweenIIPolicy(desc);
        }
        if ("BetweenIE".equals(type)) {
            return this.buildBetweenIEPolicy(desc);
        }
        if ("BetweenEI".equals(type)) {
            return this.buildBetweenEIPolicy(desc);
        }
        if ("BetweenEE".equals(type)) {
            return this.buildBetweenEEPolicy(desc);
        }
        if ("Equal".equals(type)) {
            return this.buildEqualPolicy(desc);
        }
        if ("Contains".equals(type)) {
            return this.buildContainsPolicy(desc);
        }
        if ("OneOf".equals(type)) {
            return this.buildOneOfPolicy(desc);
        }
        if ("RegExp".equals(type)) {
            return PolicyBuilder.buildRegExpPolicy(desc);
        }
        if ("CustomRule".equals(type)) {
            return PolicyBuilder.buildCustomPolicy(desc);
        }
        return null;
    }

    private ExecutionPolicy buildNotPolicy(PolicyDescriptor desc) throws Exception {
        return new ExecutionPolicy.NotRule(this.buildPolicy(desc.children.get(0)));
    }

    private ExecutionPolicy buildAndPolicy(PolicyDescriptor desc) throws Exception {
        ExecutionPolicy[] rules = new ExecutionPolicy[desc.children.size()];
        int count = 0;
        for (PolicyDescriptor child : desc.children) {
            rules[count++] = this.buildPolicy(child);
        }
        return new ExecutionPolicy.AndRule(rules);
    }

    private ExecutionPolicy buildOrPolicy(PolicyDescriptor desc) throws Exception {
        ExecutionPolicy[] rules = new ExecutionPolicy[desc.children.size()];
        int count = 0;
        for (PolicyDescriptor child : desc.children) {
            rules[count++] = this.buildPolicy(child);
        }
        return new ExecutionPolicy.OrRule(rules);
    }

    private ExecutionPolicy buildXorPolicy(PolicyDescriptor desc) throws Exception {
        ExecutionPolicy[] rules = new ExecutionPolicy[desc.children.size()];
        int count = 0;
        for (PolicyDescriptor child : desc.children) {
            rules[count++] = this.buildPolicy(child);
        }
        return new ExecutionPolicy.XorRule(rules);
    }

    private ExecutionPolicy buildLessThanPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        double value = 0.0;
        try {
            value = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
        }
        return new LessThan(desc.operands.get(0), value);
    }

    private ExecutionPolicy buildAtMostPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        double value = 0.0;
        try {
            value = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
        }
        return new AtMost(desc.operands.get(0), value);
    }

    private ExecutionPolicy buildMoreThanPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        double value = 0.0;
        try {
            value = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
        }
        return new MoreThan(desc.operands.get(0), value);
    }

    private ExecutionPolicy buildAtLeastPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        double value = 0.0;
        try {
            value = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
        }
        return new AtLeast(desc.operands.get(0), value);
    }

    private ExecutionPolicy buildBetweenIIPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        double value1 = 0.0;
        double value2 = 0.0;
        try {
            value1 = Double.valueOf(s);
            s = desc.operands.get(2);
            value2 = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
        }
        return new BetweenII(desc.operands.get(0), value1, value2);
    }

    private ExecutionPolicy buildBetweenIEPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        double value1 = 0.0;
        double value2 = 0.0;
        try {
            value1 = Double.valueOf(s);
            s = desc.operands.get(2);
            value2 = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
        }
        return new BetweenIE(desc.operands.get(0), value1, value2);
    }

    private ExecutionPolicy buildBetweenEIPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        double value1 = 0.0;
        double value2 = 0.0;
        try {
            value1 = Double.valueOf(s);
            s = desc.operands.get(2);
            value2 = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
        }
        return new BetweenEI(desc.operands.get(0), value1, value2);
    }

    private ExecutionPolicy buildBetweenEEPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        double value1 = 0.0;
        double value2 = 0.0;
        try {
            value1 = Double.valueOf(s);
            s = desc.operands.get(2);
            value2 = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
        }
        return new BetweenEE(desc.operands.get(0), value1, value2);
    }

    private ExecutionPolicy buildEqualPolicy(PolicyDescriptor desc) {
        String s = desc.operands.get(1);
        if ("string".equals(desc.valueType)) {
            boolean ignoreCase = desc.ignoreCase == null ? false : Boolean.valueOf(desc.ignoreCase);
            return new Equal(desc.operands.get(0), ignoreCase, s);
        }
        if ("numeric".equals(desc.valueType)) {
            double value = 0.0;
            try {
                value = Double.valueOf(s);
                return new Equal(desc.operands.get(0), value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
            }
        }
        return new Equal(desc.operands.get(0), Boolean.valueOf(s));
    }

    private ExecutionPolicy buildContainsPolicy(PolicyDescriptor desc) {
        boolean ignoreCase = desc.ignoreCase == null ? false : Boolean.valueOf(desc.ignoreCase);
        return new Contains(desc.operands.get(0), ignoreCase, desc.operands.get(1));
    }

    private ExecutionPolicy buildOneOfPolicy(PolicyDescriptor desc) {
        if ("numeric".equals(desc.valueType)) {
            double[] values = new double[desc.operands.size() - 1];
            for (int i = 1; i < desc.operands.size(); ++i) {
                String s = desc.operands.get(i);
                try {
                    values[i - 1] = Double.valueOf(s);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException('\'' + s + "' is not a double value", e);
                }
            }
            return new OneOf(desc.operands.get(0), values);
        }
        String[] values = new String[desc.operands.size() - 1];
        for (int i = 1; i < desc.operands.size(); ++i) {
            values[i - 1] = desc.operands.get(i);
        }
        boolean ignoreCase = Boolean.valueOf(desc.ignoreCase);
        return new OneOf(desc.operands.get(0), ignoreCase, values);
    }

    private static ExecutionPolicy buildRegExpPolicy(PolicyDescriptor desc) {
        return new RegExp(desc.operands.get(0), desc.operands.get(1));
    }

    private static ExecutionPolicy buildCustomPolicy(PolicyDescriptor desc) throws Exception {
        Class<?> clazz = Class.forName(desc.className);
        CustomPolicy policy = (CustomPolicy)clazz.newInstance();
        policy.setArgs(desc.arguments.toArray(new String[desc.arguments.size()]));
        policy.initialize();
        return policy;
    }
}

