/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.initialization;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jppf.node.initialization.InitializationHook;
import org.jppf.utils.ServiceFinder;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.UnmodifiableTypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializationHooksHandler {
    private static Logger log = LoggerFactory.getLogger(InitializationHooksHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final List<InitializationHook> hooks = new LinkedList<InitializationHook>();
    private final UnmodifiableTypedProperties initialConfiguration;

    public InitializationHooksHandler(TypedProperties initialConfiguration) {
        this.initialConfiguration = new UnmodifiableTypedProperties((Map<Object, Object>)initialConfiguration);
    }

    public void loadHooks() {
        Iterator<InitializationHook> it = ServiceFinder.lookupProviders(InitializationHook.class);
        while (it.hasNext()) {
            try {
                InitializationHook hook = it.next();
                this.hooks.add(hook);
                if (!debugEnabled) continue;
                log.debug("successfully added initialization hook " + hook.getClass().getName());
            }
            catch (Error e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void callHooks() {
        for (InitializationHook hook : this.hooks) {
            try {
                hook.initializing(this.initialConfiguration);
            }
            catch (Exception e) {
                log.error("exception caught when running initialization hook '" + hook.getClass().getName() + "' : ", (Throwable)e);
            }
        }
    }
}

