/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.idle;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.jppf.node.idle.IdleState;
import org.jppf.node.idle.IdleStateEvent;
import org.jppf.node.idle.IdleStateListener;
import org.jppf.node.idle.IdleTimeDetector;
import org.jppf.node.idle.IdleTimeDetectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleDetectionTask
extends TimerTask {
    private static Logger log = LoggerFactory.getLogger(IdleDetectionTask.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private long idleTimeout = 300000L;
    private IdleState state = IdleState.BUSY;
    private IdleTimeDetector detector = null;
    private IdleTimeDetectorFactory factory = null;
    private final List<IdleStateListener> listeners = new ArrayList<IdleStateListener>();

    public IdleDetectionTask(IdleTimeDetectorFactory factory, long idleTimeout, IdleStateListener ... initialListeners) {
        this.idleTimeout = idleTimeout;
        this.factory = factory;
        if (initialListeners != null) {
            for (IdleStateListener listener : initialListeners) {
                this.addIdleStateListener(listener);
            }
        }
        this.init();
    }

    @Override
    public void run() {
        if (this.detector == null) {
            this.cancel();
            return;
        }
        long idleTime = this.detector.getIdleTimeMillis();
        if (idleTime >= this.idleTimeout && IdleState.BUSY.equals((Object)this.state)) {
            this.changeStateTo(IdleState.IDLE);
        } else if (idleTime < this.idleTimeout && IdleState.IDLE.equals((Object)this.state)) {
            this.changeStateTo(IdleState.BUSY);
        }
    }

    private void init() {
        try {
            this.detector = this.factory.newIdleTimeDetector();
        }
        catch (Exception e) {
            this.cancel();
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public IdleState getState() {
        return this.state;
    }

    private void changeStateTo(IdleState state) {
        this.state = state;
        this.fireIdleStateEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleStateListener(IdleStateListener listener) {
        if (listener == null) {
            return;
        }
        List<IdleStateListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleStateListener(IdleStateListener listener) {
        if (listener == null) {
            return;
        }
        List<IdleStateListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIdleStateEvent() {
        IdleStateEvent event = new IdleStateEvent(this);
        List<IdleStateListener> list = this.listeners;
        synchronized (list) {
            for (IdleStateListener listener : this.listeners) {
                listener.idleStateChanged(event);
            }
        }
    }
}

