/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.node.Node;
import org.jppf.node.event.NodeLifeCycleEvent;
import org.jppf.node.event.NodeLifeCycleListener;
import org.jppf.node.event.NodeLifeCycleListenerEx;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.Task;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.ServiceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleEventHandler {
    private static Logger log = LoggerFactory.getLogger(LifeCycleEventHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final boolean propagateErrors = JPPFConfiguration.getProperties().getBoolean("jppf.node.listener.errors.propagate", true);
    private final List<NodeLifeCycleListener> listeners = new ArrayList<NodeLifeCycleListener>();
    private final Node node;

    public LifeCycleEventHandler(Node node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeLifeCycleListener(NodeLifeCycleListener listener) {
        if (listener == null) {
            return;
        }
        List<NodeLifeCycleListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeLifeCycleListener(NodeLifeCycleListener listener) {
        if (listener == null) {
            return;
        }
        List<NodeLifeCycleListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        List<NodeLifeCycleListener> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeStarting() {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(this.node);
        List<NodeLifeCycleListener> list = this.listeners;
        synchronized (list) {
            for (NodeLifeCycleListener listener : this.listeners) {
                try {
                    listener.nodeStarting(event);
                }
                catch (Throwable t) {
                    this.handleError("nodeStarting", listener, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeEnding() {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(this.node);
        List<NodeLifeCycleListener> list = this.listeners;
        synchronized (list) {
            for (NodeLifeCycleListener listener : this.listeners) {
                try {
                    listener.nodeEnding(event);
                }
                catch (Throwable t) {
                    this.handleError("nodeEnding", listener, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireJobHeaderLoaded(JPPFDistributedJob job, AbstractJPPFClassLoader cl) {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(job, cl);
        List<NodeLifeCycleListener> list = this.listeners;
        synchronized (list) {
            for (NodeLifeCycleListener listener : this.listeners) {
                try {
                    if (!(listener instanceof NodeLifeCycleListenerEx)) continue;
                    ((NodeLifeCycleListenerEx)listener).jobHeaderLoaded(event);
                }
                catch (Throwable t) {
                    this.handleError("jobHeaderLoaded", listener, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireJobStarting(JPPFDistributedJob job, AbstractJPPFClassLoader cl, List<Task> tasks, DataProvider dataProvider) {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(job, cl, tasks, dataProvider);
        List<NodeLifeCycleListener> list = this.listeners;
        synchronized (list) {
            for (NodeLifeCycleListener listener : this.listeners) {
                try {
                    listener.jobStarting(event);
                }
                catch (Throwable t) {
                    this.handleError("jobStarting", listener, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireJobEnding(JPPFDistributedJob job, AbstractJPPFClassLoader cl, List<Task> tasks, DataProvider dataProvider) {
        NodeLifeCycleEvent event = new NodeLifeCycleEvent(job, cl, tasks, dataProvider);
        List<NodeLifeCycleListener> list = this.listeners;
        synchronized (list) {
            for (NodeLifeCycleListener listener : this.listeners) {
                try {
                    listener.jobEnding(event);
                }
                catch (Throwable t) {
                    this.handleError("jobEnding", listener, t);
                }
            }
        }
    }

    public void loadListeners() {
        Iterator<NodeLifeCycleListener> it = ServiceFinder.lookupProviders(NodeLifeCycleListener.class);
        while (it.hasNext()) {
            try {
                NodeLifeCycleListener listener = it.next();
                this.addNodeLifeCycleListener(listener);
                if (!debugEnabled) continue;
                log.debug("successfully added node life cycle listener " + listener.getClass().getName());
            }
            catch (Error e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleError(String method, NodeLifeCycleListener listener, Throwable t) {
        String s = "error executing " + method + "() on an instance of " + listener.getClass() + " : ";
        if (debugEnabled) {
            log.debug(s, t);
        } else {
            log.error(s + ExceptionUtils.getMessage(t));
        }
        if (propagateErrors && t instanceof Error) {
            throw (Error)t;
        }
    }
}

