/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node;

import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jppf.JPPFException;
import org.jppf.JPPFInitializer;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFClassLoader;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.discovery.JPPFMulticastReceiver;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.logging.jmx.JmxMessageNotifier;
import org.jppf.management.JMXServer;
import org.jppf.node.Node;
import org.jppf.node.initialization.InitializationHooksHandler;
import org.jppf.process.LauncherListener;
import org.jppf.security.JPPFPolicy;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFDefaultUncaughtExceptionHandler;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.SimpleObjectLock;
import org.jppf.utils.StringUtils;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.VersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRunner {
    private static Logger log;
    private static boolean debugEnabled;
    private static AbstractJPPFClassLoader classLoader;
    private static boolean securityManagerSet;
    private static SocketWrapper nodeSocket;
    private static Hashtable<Object, Object> persistentData;
    private static ExecutorService executor;
    private static Node node;
    private static SimpleObjectLock serviceLock;
    private static String uuid;
    private static IPFilter ipFilter;
    private static TypedProperties initialConfig;
    private static InitializationHooksHandler hooksHandler;
    private static boolean shuttingDown;

    public static void main(String ... args) {
        node = null;
        try {
            new JmxMessageNotifier();
            Thread.setDefaultUncaughtExceptionHandler(new JPPFDefaultUncaughtExceptionHandler());
            int pid = SystemUtils.getPID();
            if (pid > 0) {
                System.out.println("node process id: " + pid);
            }
            String hrule = StringUtils.padRight("", '-', 80);
            log.info(hrule);
            log.info(VersionUtils.getVersionInformation());
            log.info("starting node with PID=" + pid + ", UUID=" + uuid);
            log.info(hrule);
            initialConfig = new TypedProperties((Map<Object, Object>)JPPFConfiguration.getProperties());
            if (debugEnabled) {
                log.debug("launching the JPPF node");
            }
            hooksHandler = new InitializationHooksHandler(initialConfig);
            hooksHandler.loadHooks();
            if (args == null || args.length <= 0) {
                throw new JPPFException("The node should be run with an argument representing a valid TCP port or 'noLauncher'");
            }
            if (!"noLauncher".equals(args[0])) {
                int port = Integer.parseInt(args[0]);
                new LauncherListener(port).start();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        try {
            while (true) {
                try {
                    while (true) {
                        node = NodeRunner.createNode();
                        node.run();
                    }
                }
                catch (JPPFNodeReconnectionNotification e) {
                    if (debugEnabled) {
                        log.debug("received reconnection notification");
                    }
                    if (classLoader != null) {
                        classLoader.close();
                    }
                    classLoader = null;
                    if (node != null) {
                        node.stopNode();
                    }
                    NodeRunner.unsetSecurity();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void start(String ... args) {
        NodeRunner.main(args);
        serviceLock.goToSleep();
    }

    public static void stop(String ... args) {
        serviceLock.wakeUp();
        System.exit(0);
    }

    public static Node createNode() throws Exception {
        hooksHandler.callHooks();
        if (JPPFConfiguration.getProperties().getBoolean("jppf.discovery.enabled", true)) {
            NodeRunner.discoverDriver();
        }
        NodeRunner.setSecurity();
        String className = "org.jppf.server.node.remote.JPPFRemoteNode";
        Class<?> clazz = NodeRunner.getJPPFClassLoader().loadJPPFClass(className);
        Node node = (Node)clazz.newInstance();
        if (debugEnabled) {
            log.debug("Created new node instance: " + node);
        }
        node.setSocketWrapper(nodeSocket);
        return node;
    }

    private static void discoverDriver() {
        JPPFMulticastReceiver receiver = new JPPFMulticastReceiver(ipFilter);
        JPPFConnectionInformation info = receiver.receive();
        receiver.setStopped(true);
        if (info == null) {
            if (debugEnabled) {
                log.debug("Could not auto-discover the driver connection information");
            }
            NodeRunner.restoreInitialConfig();
            return;
        }
        if (debugEnabled) {
            log.debug("Discovered driver: " + info);
        }
        TypedProperties config = JPPFConfiguration.getProperties();
        boolean ssl = config.getBoolean("jppf.ssl.enabled", false);
        config.setProperty("jppf.server.host", info.host);
        config.setProperty("jppf.server.port", String.valueOf(ssl ? info.sslServerPorts[0] : info.serverPorts[0]));
        if (info.managementHost != null) {
            config.setProperty("jppf.management.host", info.managementHost);
        }
        if (info.recoveryPort >= 0) {
            config.setProperty("jppf.recovery.server.port", "" + info.recoveryPort);
        } else {
            config.setProperty("jppf.recovery.enabled", "false");
        }
    }

    private static void restoreInitialConfig() {
        TypedProperties config = JPPFConfiguration.getProperties();
        for (Map.Entry<Object, Object> entry : initialConfig.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            config.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void setSecurity() throws Exception {
        TypedProperties props;
        String s;
        if (!securityManagerSet && (s = (props = JPPFConfiguration.getProperties()).getString("jppf.policy.file")) != null) {
            if (debugEnabled) {
                log.debug("setting security");
            }
            String rmiHostName = props.getString("jppf.management.host", "localhost");
            System.setProperty("java.rmi.server.hostname", rmiHostName);
            Policy.setPolicy(new JPPFPolicy(NodeRunner.getJPPFClassLoader()));
            System.setSecurityManager(new SecurityManager());
            securityManagerSet = true;
        }
    }

    private static void unsetSecurity() {
        if (securityManagerSet) {
            if (debugEnabled) {
                log.debug("un-setting security");
            }
            PrivilegedAction<Object> pa = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setSecurityManager(null);
                    return null;
                }
            };
            AccessController.doPrivileged(pa);
            securityManagerSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractJPPFClassLoader getJPPFClassLoader() {
        Class<JPPFClassLoader> clazz = JPPFClassLoader.class;
        synchronized (JPPFClassLoader.class) {
            if (classLoader == null) {
                PrivilegedAction<JPPFClassLoader> pa = new PrivilegedAction<JPPFClassLoader>(){

                    @Override
                    public JPPFClassLoader run() {
                        return new JPPFClassLoader(NodeRunner.class.getClassLoader());
                    }
                };
                classLoader = AccessController.doPrivileged(pa);
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return classLoader;
        }
    }

    public static synchronized void setPersistentData(Object key, Object value) {
        persistentData.put(key, value);
    }

    public static synchronized Object getPersistentData(Object key) {
        return persistentData.get(key);
    }

    public static synchronized Object removePersistentData(Object key) {
        return persistentData.remove(key);
    }

    public static Node getNode() {
        return node;
    }

    public static void shutdown(Node node, boolean restart) {
        new ShutdownOrRestart(restart, node).run();
    }

    private static void stopJmxServer() {
        try {
            final JMXServer jmxServer = node.getJmxServer();
            if (jmxServer != null) {
                jmxServer.stop();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            jmxServer.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                Future<?> f = executor.submit(r);
                try {
                    f.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getUuid() {
        return uuid;
    }

    public static synchronized boolean isShuttingDown() {
        return shuttingDown;
    }

    public static synchronized void setShuttingDown(boolean shuttingDown) {
        NodeRunner.shuttingDown = shuttingDown;
    }

    static {
        JPPFInitializer.init();
        log = LoggerFactory.getLogger(NodeRunner.class);
        debugEnabled = log.isDebugEnabled();
        classLoader = null;
        securityManagerSet = false;
        nodeSocket = null;
        persistentData = new Hashtable();
        executor = Executors.newFixedThreadPool(1);
        node = null;
        serviceLock = new SimpleObjectLock();
        uuid = JPPFConfiguration.getProperties().getString("jppf.node.uuid", JPPFUuid.normalUUID());
        ipFilter = new IPFilter(JPPFConfiguration.getProperties());
        initialConfig = null;
        hooksHandler = null;
        shuttingDown = false;
    }

    public static class ShutdownOrRestart
    implements Runnable {
        private boolean restart = false;
        private final Node node;

        public ShutdownOrRestart(boolean restart, Node node) {
            this.restart = restart;
            this.node = node;
        }

        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ShutdownOrRestart.this.node.stopNode();
                    NodeRunner.stopJmxServer();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(ShutdownOrRestart.this.restart ? 2 : 0);
                    return null;
                }
            });
        }
    }
}

