/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.net;

import java.net.Inet6Address;
import java.net.InetAddress;
import org.jppf.net.AbstractIPAddressPattern;
import org.jppf.net.PatternConfiguration;
import org.jppf.utils.Range;

public class IPv6AddressPattern
extends AbstractIPAddressPattern {
    public IPv6AddressPattern(String source) throws IllegalArgumentException {
        super(source, PatternConfiguration.IPV6_CONFIGURATION);
    }

    @Override
    public boolean matches(InetAddress ip) {
        if (!(ip instanceof Inet6Address)) {
            return false;
        }
        return super.matches(ip);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (i > 0) {
                sb.append(this.config.getCompSeparator());
            }
            Range r = (Range)this.ranges.get(i);
            sb.append(Integer.toHexString((Integer)r.getLower()));
            if (((Integer)r.getLower()).equals(r.getUpper())) continue;
            sb.append('-').append(Integer.toHexString((Integer)r.getUpper()));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("***** IP v6 *****");
        String[] ipv6patterns = new String[]{"1080:0:0:0:8:800:200C:417A", ":0::::::", "0:0:aa-bbcc:0:0:0:0:0", "1:2:3:4:5-:6:7:8"};
        String ip = "1080:0:0:0:8:800:200C:417A";
        for (int i = 0; i < ipv6patterns.length; ++i) {
            try {
                IPv6AddressPattern p = new IPv6AddressPattern(ipv6patterns[i]);
                InetAddress addr = InetAddress.getByName(ip);
                System.out.println("pattern " + i + " for source '" + ipv6patterns[i] + "' = '" + p + "', ip match = " + p.matches(addr));
                continue;
            }
            catch (Exception e) {
                System.out.println("#" + i + " : " + e.getMessage());
            }
        }
    }
}

