/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import org.jppf.net.AbstractIPAddressPattern;
import org.jppf.net.PatternConfiguration;

public class IPv4AddressPattern
extends AbstractIPAddressPattern {
    public IPv4AddressPattern(String source) throws IllegalArgumentException {
        super(source, PatternConfiguration.IPV4_CONFIGURATION);
    }

    @Override
    public boolean matches(InetAddress ip) {
        if (!(ip instanceof Inet4Address)) {
            return false;
        }
        return super.matches(ip);
    }

    public static void main(String[] args) {
        System.out.println("***** IP v4 *****");
        String[] ipv4patterns = new String[]{"192.168.1.10", "192.168.1.11", "192.168.1", "192.168", "192.168-170.1", "192.168-170.1.1-32", ".2.3.4", "1.2..4", "1.2.3.", "1.2.3.4-", "1.2.3.-4", " 1. 2 .  3. 4 - 8 ", "1.-.3.", "1.2.3.-"};
        String ip = "192.168.1.11";
        for (int i = 0; i < ipv4patterns.length; ++i) {
            try {
                IPv4AddressPattern p = new IPv4AddressPattern(ipv4patterns[i]);
                InetAddress addr = InetAddress.getByName(ip);
                System.out.println("pattern " + i + " for source '" + ipv4patterns[i] + "' = '" + p + "', ip match = " + p.matches(addr));
                continue;
            }
            catch (Exception e) {
                System.out.println("#" + i + " : " + e.getMessage());
            }
        }
    }
}

