/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.Pair;
import org.jppf.utils.PropertiesCollection;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFSystemInformation
implements PropertiesCollection<String> {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(JPPFSystemInformation.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private Map<String, TypedProperties> map = new LinkedHashMap<String, TypedProperties>();
    private final boolean local;
    private final boolean resolveInetAddressesNow;

    public JPPFSystemInformation(String uuid, boolean local, boolean resolveInetAddressesNow) {
        this.local = local;
        this.resolveInetAddressesNow = resolveInetAddressesNow;
        TypedProperties uuidProps = new TypedProperties();
        uuidProps.setProperty("jppf.uuid", uuid == null ? "" : uuid);
        this.addProperties("uuid", uuidProps);
        this.populate();
    }

    public TypedProperties getSystem() {
        return this.getProperties("system");
    }

    public TypedProperties getRuntime() {
        return this.getProperties("runtime");
    }

    public TypedProperties getEnv() {
        return this.getProperties("env");
    }

    public TypedProperties getNetwork() {
        return this.getProperties("network");
    }

    public TypedProperties getJppf() {
        return this.getProperties("jppf");
    }

    public TypedProperties getStorage() {
        return this.getProperties("storage");
    }

    public JPPFSystemInformation populate() {
        if (traceEnabled) {
            Exception e = new Exception("call stack for JPPFSystemInformation.populate(" + this.resolveInetAddressesNow + ")");
            log.trace(e.getMessage(), (Throwable)e);
        }
        this.addProperties("system", SystemUtils.getSystemProperties());
        this.addProperties("runtime", SystemUtils.getRuntimeInformation());
        this.addProperties("env", SystemUtils.getEnvironment());
        this.addProperties("jppf", new TypedProperties((Map<Object, Object>)JPPFConfiguration.getProperties()));
        this.getJppf().setProperty("jppf.channel.local", String.valueOf(this.local));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JPPFSystemInformation.this.addProperties("network", SystemUtils.getNetwork());
            }
        };
        if (this.resolveInetAddressesNow) {
            r.run();
        } else {
            new Thread(r).start();
        }
        this.addProperties("storage", SystemUtils.getStorageInformation());
        if (this.getProperties("uuid") == null) {
            this.addProperties("uuid", new TypedProperties());
        }
        return this;
    }

    private HostIP[] parseIPV4Addresses() {
        String s = this.getNetwork().getString("ipv4.addresses");
        if (s == null || "".equals(s.trim())) {
            return null;
        }
        return this.parseAddresses(s);
    }

    private HostIP[] parseIPV6Addresses() {
        String s = this.getNetwork().getString("ipv6.addresses");
        if (s == null || "".equals(s.trim())) {
            return null;
        }
        return this.parseAddresses(s);
    }

    private HostIP[] parseAddresses(String addresses) {
        String[] pairs = addresses.split("\\s");
        if (pairs == null || pairs.length <= 0) {
            return null;
        }
        HostIP[] result = new HostIP[pairs.length];
        int count = 0;
        for (String pair : pairs) {
            String[] comps = pair.split("|");
            if (comps[0] != null && "".equals(comps[0].trim())) {
                comps[0] = null;
            }
            result[count++] = new HostIP(comps[0], comps[1]);
        }
        return result;
    }

    public TypedProperties getUuid() {
        return this.getProperties("uuid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedProperties[] getPropertiesArray() {
        Map<String, TypedProperties> map = this.map;
        synchronized (map) {
            return this.map.values().toArray(new TypedProperties[this.map.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProperties(String key, TypedProperties properties) {
        Map<String, TypedProperties> map = this.map;
        synchronized (map) {
            this.map.put(key, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedProperties getProperties(String key) {
        Map<String, TypedProperties> map = this.map;
        synchronized (map) {
            return this.map.get(key);
        }
    }

    public static class HostIP
    extends Pair<String, String> {
        public HostIP(String first, String second) {
            super(first, second);
        }

        public String hostName() {
            return (String)this.first();
        }

        public String ipAddress() {
            return (String)this.second();
        }
    }
}

