/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.io.Serializable;
import org.jppf.utils.LocalizationUtils;

public class JPPFNodeState
implements Serializable {
    private static final String I18N = "org.jppf.server.i18n.messages";
    private static final long serialVersionUID = 1L;
    private ConnectionState connectionStatus = ConnectionState.UNKNOWN;
    private ExecutionState executionStatus = ExecutionState.IDLE;
    private int nbTasksExecuted = 0;
    private long cpuTime = 0L;
    private int threadPoolSize = -1;
    private int threadPriority = -1;

    public synchronized Serializable getTaskNotification() {
        return null;
    }

    public synchronized void setTaskEvent(Serializable taskEvent) {
    }

    public synchronized int getNbTasksExecuted() {
        return this.nbTasksExecuted;
    }

    public synchronized void setNbTasksExecuted(int nbTasksExecuted) {
        this.nbTasksExecuted = nbTasksExecuted;
    }

    public synchronized ConnectionState getConnectionStatus() {
        return this.connectionStatus;
    }

    public synchronized void setConnectionStatus(ConnectionState connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public synchronized ExecutionState getExecutionStatus() {
        return this.executionStatus;
    }

    public synchronized void setExecutionStatus(ExecutionState executionStatus) {
        this.executionStatus = executionStatus;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public synchronized long getCpuTime() {
        return this.cpuTime;
    }

    public synchronized void setCpuTime(long cpuTime) {
        this.cpuTime = cpuTime;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public JPPFNodeState copy() {
        JPPFNodeState s = new JPPFNodeState();
        s.setNbTasksExecuted(this.getNbTasksExecuted());
        s.setConnectionStatus(this.getConnectionStatus());
        s.setExecutionStatus(this.getExecutionStatus());
        s.setThreadPoolSize(this.getThreadPoolSize());
        s.setThreadPriority(this.getThreadPriority());
        s.setCpuTime(this.getCpuTime());
        return s;
    }

    public static enum ExecutionState {
        UNKNOWN("unknown"),
        IDLE("node.idle"),
        EXECUTING("node.executing");

        private final String displayName;

        private ExecutionState(String msg) {
            this.displayName = LocalizationUtils.getLocalized(JPPFNodeState.I18N, msg);
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum ConnectionState {
        UNKNOWN("unknown"),
        CONNECTED("node.connected"),
        DISCONNECTED("node.disconnected");

        private final String displayName;

        private ConnectionState(String msg) {
            this.displayName = LocalizationUtils.getLocalized(JPPFNodeState.I18N, msg);
        }

        public String toString() {
            return this.displayName;
        }
    }
}

