/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.io.Serializable;
import org.jppf.management.JPPFSystemInformation;

public class JPPFManagementInfo
implements Serializable,
Comparable<JPPFManagementInfo> {
    private static final long serialVersionUID = 1L;
    public static final byte DRIVER = 0;
    public static final byte NODE = 1;
    public static final byte PEER = 2;
    public static final byte LOCAL = 64;
    protected static final byte TYPE_MASK = 15;
    private final String host;
    private final int port;
    private String id = null;
    private final byte type;
    private final boolean secure;
    private transient JPPFSystemInformation systemInfo = null;

    public JPPFManagementInfo(String host, int port, String id) {
        this(host, port, id, 1, false);
    }

    public JPPFManagementInfo(String host, int port, String id, int type) {
        this(host, port, id, type, false);
    }

    public JPPFManagementInfo(String host, int port, String id, int type, boolean secure) {
        this.host = host;
        this.port = port;
        this.id = id;
        this.type = (byte)type;
        this.secure = secure;
    }

    public synchronized String getHost() {
        return this.host;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPPFManagementInfo other = (JPPFManagementInfo)obj;
        if (other.id == null) {
            return this.id == null;
        }
        return this.id != null && this.id.equals(other.id);
    }

    @Override
    public int compareTo(JPPFManagementInfo o) {
        if (o == null) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        int n = -1 * this.host.compareTo(o.getHost());
        if (n != 0) {
            return n;
        }
        if (this.port > o.getPort()) {
            return 1;
        }
        if (this.port < o.getPort()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append(this.host).append(':').append(this.port);
        sb.append(", type=").append(this.type & 0xF);
        sb.append(", id=").append(this.id);
        sb.append(']');
        return sb.toString();
    }

    public synchronized JPPFSystemInformation getSystemInfo() {
        return this.systemInfo;
    }

    public synchronized void setSystemInfo(JPPFSystemInformation systemInfo) {
        this.systemInfo = systemInfo;
    }

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type & 0xF;
    }

    public boolean isPeer() {
        return (this.type & 0xF) == 2;
    }

    public boolean isNode() {
        return (this.type & 0xF) == 1;
    }

    public boolean isDriver() {
        return (this.type & 0xF) == 0;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isLocal() {
        return (this.type & 0x40) == 64;
    }
}

