/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import org.jppf.management.AbstractJMXServer;
import org.jppf.management.JMXMPServer;
import org.jppf.management.JMXServer;
import org.jppf.management.JMXServerImpl;
import org.jppf.utils.JPPFConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXServerFactory {
    private static Logger log = LoggerFactory.getLogger(JMXServerFactory.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean usingRMIConnector = "rmi".equalsIgnoreCase(JPPFConfiguration.getProperties().getString("jppf.management.connector", "jmxmp"));

    private static JMXServer createServer(String uuid, String suffix, boolean ssl) throws Exception {
        AbstractJMXServer server;
        AbstractJMXServer abstractJMXServer = server = !usingRMIConnector && JMXServerFactory.isJMXMPPresent() ? new JMXMPServer(uuid, ssl) : new JMXServerImpl(suffix, uuid);
        if (debugEnabled) {
            log.debug("created JMX server: " + server);
        }
        return server;
    }

    public static JMXServer createServer(String uuid, boolean ssl) throws Exception {
        JMXMPServer server = new JMXMPServer(uuid, ssl);
        if (debugEnabled) {
            log.debug("created JMX server: " + server);
        }
        return server;
    }

    public static boolean isJMXMPPresent() {
        try {
            Class<?> c = JMXServerFactory.class.getClassLoader().loadClass("javax.management.remote.jmxmp.JMXMPConnectorServer");
            if (debugEnabled) {
                log.debug("jmxmp classes are present in the classpath");
            }
            return true;
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug("jmxmp classes are not present in the classpath");
            }
            return false;
        }
    }

    public static boolean isUsingRMIConnector() {
        return usingRMIConnector;
    }
}

