/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.util.Map;
import org.jppf.classloader.DelegationModel;
import org.jppf.management.JMXConnectionWrapper;
import org.jppf.management.JPPFNodeAdminMBean;
import org.jppf.management.JPPFNodeState;
import org.jppf.management.JPPFSystemInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXNodeConnectionWrapper
extends JMXConnectionWrapper
implements JPPFNodeAdminMBean {
    private static Logger log = LoggerFactory.getLogger(JMXNodeConnectionWrapper.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public JMXNodeConnectionWrapper() {
        this.local = true;
    }

    public JMXNodeConnectionWrapper(String host, int port) {
        this(host, port, false);
    }

    public JMXNodeConnectionWrapper(String host, int port, boolean secure) {
        super(host, port, secure);
        this.local = false;
    }

    @Override
    public JPPFNodeState state() throws Exception {
        return (JPPFNodeState)this.invoke("org.jppf:name=admin,type=node", "state", null, null);
    }

    @Override
    public void updateThreadPoolSize(Integer size) throws Exception {
        this.invoke("org.jppf:name=admin,type=node", "updateThreadPoolSize", new Object[]{size}, new String[]{"java.lang.Integer"});
    }

    @Override
    public JPPFSystemInformation systemInformation() throws Exception {
        return (JPPFSystemInformation)this.invoke("org.jppf:name=admin,type=node", "systemInformation", null, null);
    }

    @Override
    public void shutdown() throws Exception {
        if (debugEnabled) {
            log.debug("node " + this + " shutdown requested");
        }
        this.invoke("org.jppf:name=admin,type=node", "shutdown", null, null);
    }

    @Override
    public void restart() throws Exception {
        if (debugEnabled) {
            log.debug("node " + this + " restart requested");
        }
        this.invoke("org.jppf:name=admin,type=node", "restart", null, null);
    }

    @Override
    public void resetTaskCounter() throws Exception {
        this.invoke("org.jppf:name=admin,type=node", "resetTaskCounter", null, null);
    }

    @Override
    public void setTaskCounter(Integer n) throws Exception {
        this.setAttribute("org.jppf:name=admin,type=node", "TaskCounter", n);
    }

    @Override
    public void updateThreadsPriority(Integer newPriority) throws Exception {
        this.invoke("org.jppf:name=admin,type=node", "updateThreadsPriority", new Object[]{newPriority}, new String[]{"java.lang.Integer"});
    }

    public void updateConfiguration(Map config, Boolean reconnect) throws Exception {
        this.invoke("org.jppf:name=admin,type=node", "updateConfiguration", new Object[]{config, reconnect}, new String[]{"java.util.Map", "java.lang.Boolean"});
    }

    @Override
    public void cancelJob(String jobUuid, Boolean requeue) throws Exception {
        this.invoke("org.jppf:name=admin,type=node", "cancelJob", new Object[]{jobUuid, requeue}, new String[]{"java.lang.String", "java.lang.Boolean"});
    }

    @Override
    public DelegationModel getDelegationModel() throws Exception {
        return (DelegationModel)((Object)this.getAttribute("org.jppf:name=admin,type=node", "DelegationModel"));
    }

    @Override
    public void setDelegationModel(DelegationModel model) throws Exception {
        this.setAttribute("org.jppf:name=admin,type=node", "DelegationModel", (Object)model);
    }
}

