/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.HashMap;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.jppf.management.AbstractJMXServer;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXMPServer
extends AbstractJMXServer {
    private static Logger log = LoggerFactory.getLogger(JMXMPServer.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public JMXMPServer() {
        this(new JPPFUuid().toString(), false);
    }

    public JMXMPServer(String id, boolean ssl) {
        this.id = id;
        this.ssl = ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ClassLoader cl) throws Exception {
        if (debugEnabled) {
            log.debug("starting remote connector server");
        }
        ClassLoader tmp = Thread.currentThread().getContextClassLoader();
        lock.lock();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            this.server = ManagementFactory.getPlatformMBeanServer();
            TypedProperties props = JPPFConfiguration.getProperties();
            this.managementHost = NetworkUtils.getManagementHost();
            this.managementPort = !this.ssl ? props.getInt("jppf.management.port", 11198) : props.getInt("jppf.management.ssl.port", 11193);
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.default.class.loader", cl);
            env.put("jmx.remote.protocol.provider.class.loader", cl);
            if (this.ssl) {
                SSLHelper.configureJMXProperties(env);
            }
            boolean found = false;
            JMXServiceURL url = null;
            while (!found) {
                try {
                    InetAddress addr = InetAddress.getByName(this.managementHost);
                    String host = addr instanceof Inet6Address ? "[" + this.managementHost + "]" : this.managementHost;
                    url = new JMXServiceURL("service:jmx:jmxmp://" + host + ':' + this.managementPort);
                    this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, this.server);
                    this.connectorServer.start();
                    found = true;
                }
                catch (Exception e) {
                    String s = e.getMessage();
                    if (e instanceof BindException || s != null && s.toLowerCase().contains("bind")) {
                        if (this.managementPort >= 65530) {
                            this.managementPort = 1024;
                        }
                        ++this.managementPort;
                        continue;
                    }
                    throw e;
                }
            }
            this.stopped = false;
            if (debugEnabled) {
                log.debug("JMXConnectorServer started at URL " + url);
            }
        }
        finally {
            lock.unlock();
            Thread.currentThread().setContextClassLoader(tmp);
        }
    }
}

