/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jppf.JPPFException;
import org.jppf.management.JMXConnectionThread;
import org.jppf.management.JMXServerFactory;
import org.jppf.management.JPPFAdminMBean;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConnectionWrapper
extends ThreadSynchronization
implements JPPFAdminMBean {
    private static Logger log = LoggerFactory.getLogger(JMXConnectionWrapper.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    protected JMXServiceURL url = null;
    protected JMXConnector jmxc = null;
    protected AtomicReference<MBeanServerConnection> mbeanConnection = new AtomicReference<Object>(null);
    protected String host = null;
    protected int port = 0;
    protected AtomicReference<JMXConnectionThread> connectionThread = new AtomicReference<Object>(null);
    protected String idString = null;
    protected String displayName = null;
    protected AtomicBoolean connected = new AtomicBoolean(false);
    protected boolean local = false;
    protected Map<String, Object> env = new HashMap<String, Object>();
    protected boolean secure = false;
    private final Object connectionLock = new Object();

    public JMXConnectionWrapper() {
        this.local = true;
    }

    private JMXConnectionWrapper(String host, int port, String rmiSuffix) {
        this.host = host;
        this.port = port;
        try {
            this.displayName = this.idString = host + ':' + port;
            String s = null;
            s = !JMXServerFactory.isUsingRMIConnector() && JMXServerFactory.isJMXMPPresent() ? "service:jmx:jmxmp://" + this.idString : "service:jmx:rmi:///jndi/rmi://" + this.idString + rmiSuffix;
            this.url = new JMXServiceURL(s);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.local = false;
    }

    public JMXConnectionWrapper(String host, int port, boolean ssl) {
        try {
            this.host = NetworkUtils.isIPv6Address(host) ? "[" + host + "]" : host;
            this.port = port;
            this.secure = ssl;
            this.displayName = this.idString = this.host + ':' + this.port;
            this.url = new JMXServiceURL("service:jmx:jmxmp://" + this.idString);
            if (ssl) {
                SSLHelper.configureJMXProperties(this.env);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.local = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        if (this.isConnected()) {
            return;
        }
        if (this.local) {
            this.mbeanConnection.set(ManagementFactory.getPlatformMBeanServer());
            this.setConnectedStatus(true);
        } else {
            JMXConnectionThread jct = null;
            boolean jctNull = true;
            JMXConnectionWrapper jMXConnectionWrapper = this;
            synchronized (jMXConnectionWrapper) {
                jct = this.connectionThread.get();
                boolean bl = jctNull = jct == null;
                if (jctNull) {
                    jct = new JMXConnectionThread(this);
                    this.connectionThread.set(jct);
                    Thread t = new Thread((Runnable)jct, "JMX connection " + this.getId());
                    t.setDaemon(true);
                    t.start();
                }
            }
            if (!jctNull && !jct.isConnecting()) {
                jct.resume();
            }
        }
    }

    public void connectAndWait(long timeout) {
        long elapsed;
        if (this.isConnected()) {
            return;
        }
        long start = System.currentTimeMillis();
        long max = timeout > 0L ? timeout : Long.MAX_VALUE;
        this.connect();
        while (!this.isConnected() && (elapsed = System.currentTimeMillis() - start) < max) {
            this.goToSleep(max - elapsed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performConnection() throws Exception {
        this.setConnectedStatus(false);
        Object object = this.connectionLock;
        synchronized (object) {
            this.jmxc = JMXConnectorFactory.connect(this.url, this.env);
        }
        object = this;
        synchronized (object) {
            this.mbeanConnection.set(this.jmxc.getMBeanServerConnection());
            try {
                this.setHost(InetAddress.getByName(this.host).getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.setConnectedStatus(true);
        if (debugEnabled) {
            log.debug(this.getId() + " JMX connection successfully established");
        }
    }

    public void close() throws Exception {
        if (this.connectionThread.get() != null) {
            this.connectionThread.get().close();
        }
        if (this.jmxc != null) {
            this.jmxc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String name, String methodName, Object[] params, String[] signature) throws Exception {
        if (!this.isConnected() || this.connectionThread.get() != null && this.connectionThread.get().isConnecting()) {
            return null;
        }
        JMXConnectionWrapper jMXConnectionWrapper = this;
        synchronized (jMXConnectionWrapper) {
            Object result;
            block11: {
                result = null;
                try {
                    ObjectName mbeanName = new ObjectName(name);
                    result = this.getMbeanConnection().invoke(mbeanName, methodName, params, signature);
                }
                catch (IOException e) {
                    block10: {
                        if (debugEnabled) {
                            log.debug(this.getId() + " : error while invoking the JMX connection", (Throwable)e);
                        }
                        this.setConnectedStatus(false);
                        try {
                            if (this.jmxc != null) {
                                this.jmxc.close();
                            }
                        }
                        catch (Exception e2) {
                            if (!debugEnabled) break block10;
                            log.debug(e2.getMessage(), (Throwable)e2);
                        }
                    }
                    if (this.connectionThread.get().isConnecting()) break block11;
                    this.connectionThread.get().resume();
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name, String attribute) throws Exception {
        if (!this.isConnected() || this.connectionThread.get() != null && this.connectionThread.get().isConnecting()) {
            return null;
        }
        JMXConnectionWrapper jMXConnectionWrapper = this;
        synchronized (jMXConnectionWrapper) {
            Object result = null;
            try {
                ObjectName mbeanName = new ObjectName(name);
                result = this.getMbeanConnection().getAttribute(mbeanName, attribute);
            }
            catch (IOException e) {
                block11: {
                    this.setConnectedStatus(false);
                    try {
                        if (this.jmxc != null) {
                            this.jmxc.close();
                        }
                    }
                    catch (Exception e2) {
                        if (!debugEnabled) break block11;
                        log.debug(e2.getMessage(), (Throwable)e2);
                    }
                }
                if (!this.connectionThread.get().isConnecting()) {
                    this.connectionThread.get().resume();
                }
                if (debugEnabled) {
                    log.debug(this.getId() + " : error while invoking the JMX connection", (Throwable)e);
                }
                throw e;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, String attribute, Object value) throws Exception {
        if (!this.isConnected() || this.connectionThread.get() != null && this.connectionThread.get().isConnecting()) {
            return;
        }
        JMXConnectionWrapper jMXConnectionWrapper = this;
        synchronized (jMXConnectionWrapper) {
            try {
                ObjectName mbeanName = new ObjectName(name);
                this.getMbeanConnection().setAttribute(mbeanName, new Attribute(attribute, value));
            }
            catch (IOException e) {
                block11: {
                    this.setConnectedStatus(false);
                    try {
                        if (this.jmxc != null) {
                            this.jmxc.close();
                        }
                    }
                    catch (Exception e2) {
                        if (!debugEnabled) break block11;
                        log.debug(e2.getMessage(), (Throwable)e2);
                    }
                }
                if (!this.connectionThread.get().isConnecting()) {
                    this.connectionThread.get().resume();
                }
                if (debugEnabled) {
                    log.debug(this.getId() + " : error while invoking the JMX connection", (Throwable)e);
                }
                throw e;
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.displayName = this.host + ':' + this.port;
    }

    public int getPort() {
        return this.port;
    }

    public String getId() {
        return this.idString;
    }

    public JMXServiceURL getURL() {
        return this.url;
    }

    public MBeanServerConnection getMbeanConnection() {
        return this.mbeanConnection.get();
    }

    protected void setConnectedStatus(boolean status) {
        this.connected.set(status);
        this.wakeUp();
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public <T> T getProxy(String name, Class<T> inf) throws Exception {
        return this.getProxy(new ObjectName(name), inf);
    }

    public <T> T getProxy(ObjectName objectName, Class<T> inf) throws Exception {
        if (!this.isConnected()) {
            this.connect();
        }
        if (this.isConnected()) {
            MBeanServerConnection mbsc = this.getMbeanConnection();
            return MBeanServerInvocationHandler.newProxyInstance(mbsc, objectName, inf, true);
        }
        return null;
    }

    @Override
    public JPPFSystemInformation systemInformation() throws Exception {
        throw new JPPFException("this method is not implemented");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.getClass().getSimpleName()).append('[');
        sb.append("url=").append(this.url);
        sb.append(", connected=").append(this.connected);
        sb.append(", local=").append(this.local);
        sb.append(", secure=").append(this.secure);
        sb.append(']');
        return sb.toString();
    }
}

