/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import org.jppf.management.JMXConnectionWrapper;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConnectionThread
extends ThreadSynchronization
implements Runnable {
    static Logger log = LoggerFactory.getLogger(JMXConnectionThread.class);
    static boolean debugEnabled = log.isDebugEnabled();
    private boolean suspended = false;
    private boolean connecting = true;
    private JMXConnectionWrapper connectionWrapper = null;

    public JMXConnectionThread(JMXConnectionWrapper connectionWrapper) {
        this.connectionWrapper = connectionWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isStopped()) {
            if (this.isSuspended()) {
                if (debugEnabled) {
                    log.debug(this.connectionWrapper.getId() + " about to go to sleep");
                }
                this.goToSleep();
                continue;
            }
            if (!this.isConnecting()) continue;
            try {
                if (debugEnabled) {
                    log.debug(this.connectionWrapper.getId() + " about to perform connection attempts");
                }
                this.connectionWrapper.performConnection();
                if (debugEnabled) {
                    log.debug(this.connectionWrapper.getId() + " about to suspend connection attempts");
                }
                this.suspend();
                this.connectionWrapper.wakeUp();
            }
            catch (Exception ignored) {
                if (debugEnabled) {
                    log.debug(this.connectionWrapper.getId() + " JMX URL = " + this.connectionWrapper.getURL(), (Throwable)ignored);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.connectionWrapper.wakeUp();
            }
        }
    }

    public synchronized void suspend() {
        if (debugEnabled) {
            log.debug(this.connectionWrapper.getId() + " suspending connection attempts");
        }
        this.setConnecting(false);
        this.setSuspended(true);
        this.wakeUp();
    }

    public synchronized void resume() {
        if (debugEnabled) {
            log.debug(this.connectionWrapper.getId() + " resuming connection attempts");
        }
        this.setConnecting(true);
        this.setSuspended(false);
        this.wakeUp();
    }

    public synchronized void close() {
        this.setConnecting(false);
        this.setStopped(true);
        this.wakeUp();
    }

    public synchronized boolean isConnecting() {
        return this.connecting;
    }

    public synchronized void setConnecting(boolean connecting) {
        this.connecting = connecting;
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public synchronized void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }
}

