/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.logging.jmx;

import java.lang.management.ManagementFactory;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import org.jppf.logging.jmx.JmxLogger;
import org.jppf.logging.jmx.JmxLoggerImpl;
import org.jppf.utils.ExceptionUtils;

public class JmxMessageNotifier {
    private JmxLogger jmxLogger = null;
    private ObjectName objectName = null;
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static MBeanServer server = null;
    private static boolean initializing = false;

    public JmxMessageNotifier() {
        this.initializeJmx("org.jppf:name=jmxlogger,type=all");
    }

    public JmxMessageNotifier(String name) {
        this.initializeJmx("org.jppf:name=jmxlogger,type=all");
    }

    public void sendMessage(String message) {
        if (this.jmxLogger == null) {
            return;
        }
        this.jmxLogger.log(message);
    }

    private JmxLogger getJmxLogger() {
        return this.jmxLogger;
    }

    private void initializeJmx(String name) {
        this.initObjectName(name);
        if (this.objectName == null) {
            return;
        }
        this.registerMBean();
        if (server == null) {
            return;
        }
        this.initializeProxy();
    }

    private void initObjectName(String name) {
        try {
            if (this.objectName == null) {
                this.objectName = new ObjectName(name);
            }
        }
        catch (Exception e) {
            try {
                System.out.println("Error in logging configuration: JMX logger name '" + name + "' is invalid (" + ExceptionUtils.getMessage(e) + ')');
                this.objectName = new ObjectName("org.jppf:name=jmxlogger,type=all");
            }
            catch (Exception e2) {
                System.out.println("Failed to initialize jmx based logging with default MBean name:" + ExceptionUtils.getMessage(e2));
            }
        }
    }

    private void initializeProxy() {
        try {
            if (this.jmxLogger == null) {
                this.jmxLogger = MBeanServerInvocationHandler.newProxyInstance(server, this.objectName, JmxLogger.class, true);
            }
        }
        catch (Exception e) {
            System.out.println("Error initializing the JMX logger MBean '" + this.objectName + "' : " + ExceptionUtils.getMessage(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMBean() {
        LOCK.lock();
        try {
            if (initializing) {
                return;
            }
            initializing = true;
            if (server != null) {
                return;
            }
            server = JmxMessageNotifier.obtainMBeanServer();
            if (server == null) {
                return;
            }
            if (server.isRegistered(this.objectName)) {
                return;
            }
            try {
                JmxLoggerImpl impl = new JmxLoggerImpl();
                StandardEmitterMBean mbean = new StandardEmitterMBean(impl, JmxLogger.class, (NotificationEmitter)impl);
                server.registerMBean(mbean, this.objectName);
            }
            catch (Exception e) {
                System.out.println("Error registering the JMX logger MBean '" + this.objectName + "' : " + ExceptionUtils.getMessage(e));
            }
        }
        finally {
            initializing = false;
            LOCK.unlock();
        }
    }

    private static MBeanServer obtainMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception e) {
            System.out.println("Failed to obtain the MBean server: " + ExceptionUtils.getMessage(e));
            return null;
        }
    }
}

